/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.layers.primitive;

import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.MarkerLayer;
import nl.gjorgdy.pl3xmarkers.core.markers.IconMarkerBuilder;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class IconMarkerLayer
extends MarkerLayer {
    public final String iconId;
    public final String key;
    public final String label;
    @Language(value="HTML")
    public final String tooltip;

    public IconMarkerLayer(String icon, String key, String label, String tooltip, @NotNull World world) {
        super(key, label, world);
        this.iconId = icon;
        this.key = key;
        this.label = label;
        this.tooltip = tooltip;
    }

    @Override
    public void load() {
        Pl3xMarkersCore.iconMarkerRepository().getMarkers(this.getWorld().getKey(), this.key).forEach(marker -> this.addIconMarker(marker.getX(), marker.getZ()));
    }

    @Override
    public boolean isInWorld(@NotNull World world) {
        return true;
    }

    public void addSimpleMarker(int x, int z) {
        boolean added = Pl3xMarkersCore.iconMarkerRepository().addMarker(this.getWorld().getKey(), this.key, x, z);
        if (added) {
            this.addIconMarker(x, z);
        }
    }

    public void removeMarker(int x, int z) {
        Pl3xMarkersCore.iconMarkerRepository().removeMarker(this.getWorld().getKey(), this.key, x, z);
        super.removeMarker(this.toMarkerKey(x, z));
    }

    private void addIconMarker(int x, int z) {
        this.addMarker(this.createIconMarker(x, z));
    }

    protected Marker<?> createIconMarker(int x, int z) {
        return IconMarkerBuilder.newIconMarker(this.toMarkerKey(x, z), this.iconId, x, z).centerIcon(16, 16).addTooltip(this.tooltip).build();
    }
}

