/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.markers.layer.Layer;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.core.Layers;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.AreaMarkerLayer;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.IconMarkerLayer;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.MarkerLayer;
import org.intellij.lang.annotations.Language;

public class Api {
    public ExecutorService executor = new ThreadPoolExecutor(2, 8, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000));

    private static World getWorld(String worldIdentifier) {
        World world = (World)Pl3xMap.api().getWorldRegistry().get(worldIdentifier);
        if (world == null) {
            throw new RuntimeException("World not found " + worldIdentifier);
        }
        return world;
    }

    public void registerMarkerLayer(Function<World, MarkerLayer> function) {
        Pl3xMarkersCore.pl3xHandler().registerMarkerLayer(function);
    }

    public void registerIconImage(String path, String filename, String filetype) {
        Pl3xMarkersCore.pl3xHandler().registerIconImage(path, filename, filetype);
    }

    public void addAreaPoint(String worldIdentifier, @Language(value="HTML") String label, int color, int x, int z) {
        this.executor.execute(() -> {
            Layer layer = (Layer)Api.getWorld(worldIdentifier).getLayerRegistry().get(Layers.Keys.AREAS);
            if (layer instanceof AreaMarkerLayer) {
                AreaMarkerLayer aml = (AreaMarkerLayer)layer;
                aml.addPoint(label, color, x, z);
            }
        });
    }

    public void removeAreaPoint(String worldIdentifier, @Language(value="HTML") String label, int color, int x, int z) {
        this.executor.execute(() -> {
            Layer layer = (Layer)Api.getWorld(worldIdentifier).getLayerRegistry().get(Layers.Keys.AREAS);
            if (layer instanceof AreaMarkerLayer) {
                AreaMarkerLayer aml = (AreaMarkerLayer)layer;
                aml.removePoint(label, color, x, z);
            }
        });
    }

    public void addNetherPortalIconMarker(String worldIdentifier, int x, int z) {
        this.addIconMarker(worldIdentifier, Layers.Keys.NETHER_PORTALS, x, z);
    }

    public void addEndGatewayIconMarker(String worldIdentifier, int x, int z) {
        this.addIconMarker(worldIdentifier, Layers.Keys.END_GATEWAYS, x, z);
    }

    public void addEndPortalIconMarker(String worldIdentifier, int x, int z) {
        this.addIconMarker(worldIdentifier, Layers.Keys.END_PORTALS, x, z);
    }

    public void addBeaconIconMarker(String worldIdentifier, int x, int z) {
        this.addIconMarker(worldIdentifier, Layers.Keys.BEACONS, x, z);
    }

    public void addIconMarker(String worldIdentifier, String layerKey, int x, int z) {
        this.executor.execute(() -> {
            Layer layer = (Layer)Api.getWorld(worldIdentifier).getLayerRegistry().get(layerKey);
            if (layer instanceof IconMarkerLayer) {
                IconMarkerLayer simpleIconMarkerLayer = (IconMarkerLayer)layer;
                simpleIconMarkerLayer.addSimpleMarker(x, z);
            }
        });
    }

    public void removeNetherPortalIconMarker(String worldIdentifier, int x, int z) {
        this.removeIconMarker(worldIdentifier, Layers.Keys.NETHER_PORTALS, x, z);
    }

    public void removeEndGatewayIconMarker(String worldIdentifier, int x, int z) {
        this.removeIconMarker(worldIdentifier, Layers.Keys.END_GATEWAYS, x, z);
    }

    public void removeEndPortalIconMarker(String worldIdentifier, int x, int z) {
        this.removeIconMarker(worldIdentifier, Layers.Keys.END_PORTALS, x, z);
    }

    public void removeBeaconIconMarker(String worldIdentifier, int x, int z) {
        this.removeIconMarker(worldIdentifier, Layers.Keys.BEACONS, x, z);
    }

    public void removeIconMarker(String worldIdentifier, String layerKey, int x, int z) {
        this.executor.execute(() -> {
            Layer layer = (Layer)Api.getWorld(worldIdentifier).getLayerRegistry().get(layerKey);
            if (layer instanceof IconMarkerLayer) {
                IconMarkerLayer markerLayer = (IconMarkerLayer)layer;
                markerLayer.removeMarker(x, z);
            }
        });
    }
}

