/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.repositories;

import com.j256.ormlite.stmt.DeleteBuilder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nl.gjorgdy.pl3xmarkers.core.Database;
import nl.gjorgdy.pl3xmarkers.core.entities.IconMarkerEntity;

public class IconMarkerRepository {
    private final Database database;

    public IconMarkerRepository(Database database) {
        this.database = database;
    }

    public List<IconMarkerEntity> getMarkers(String worldKey, String layerKey) {
        try {
            return this.database.markers.queryBuilder().where().eq("world", worldKey).and().eq("layer", layerKey).query();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return new ArrayList<IconMarkerEntity>();
        }
    }

    public boolean addMarker(String worldKey, String layerKey, int x, int z) {
        try {
            IconMarkerEntity marker = new IconMarkerEntity(worldKey, layerKey, x, z);
            return this.database.markers.create(marker) > 0;
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 0) {
                System.out.println(e.getMessage());
            }
            return false;
        }
    }

    public void removeMarker(String worldKey, String layerKey, int x, int z) {
        try {
            DeleteBuilder<IconMarkerEntity, String> deleteBuilder = this.database.markers.deleteBuilder();
            deleteBuilder.where().eq("world", worldKey).and().eq("layer", layerKey).and().eq("x", x).and().eq("z", z);
            deleteBuilder.delete();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

