/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xMarkers.paper.helpers;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import nl.gjorgdy.pl3xmarkers.core.objects.InteractionResult;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class FeedbackHelper {
    public static void sendFeedback(InteractionResult result, Player player) {
        if (result.state() == InteractionResult.State.SKIP || Pl3xMarkersCore.isFeedbackDisabled()) {
            return;
        }
        if (Pl3xMarkersCore.areFeedbackMessagesEnabled()) {
            player.sendActionBar(Component.text((String)result.message()).color(TextColor.color((int)FeedbackHelper.color(result.state()))));
        }
        if (Pl3xMarkersCore.areFeedbackSoundsEnabled()) {
            player.playSound(player.getLocation(), FeedbackHelper.sound(result.state()), 1.0f, 1.5f);
        }
    }

    public static void sendFeedback(InteractionResult result, Location pos) {
        if (result.state() == InteractionResult.State.SKIP) {
            return;
        }
        int color = FeedbackHelper.color(result.state());
        Sound sound = FeedbackHelper.sound(result.state());
        pos.getWorld().getNearbyPlayers(pos, 8.0).forEach(player -> {
            if (Pl3xMarkersCore.areFeedbackMessagesEnabled()) {
                player.sendActionBar(Component.text((String)result.message()).color(TextColor.color((int)color)));
            }
            if (Pl3xMarkersCore.areFeedbackSoundsEnabled()) {
                player.playSound(player.getLocation(), sound, 1.0f, 1.5f);
            }
        });
    }

    private static int color(InteractionResult.State state) {
        return switch (state) {
            case InteractionResult.State.ADDED -> 0x59FF59;
            case InteractionResult.State.REMOVED -> 0x6A6A6A;
            case InteractionResult.State.FAILURE -> 0xFF5959;
            default -> 0xFFFFFF;
        };
    }

    private static Sound sound(InteractionResult.State state) {
        return switch (state) {
            case InteractionResult.State.ADDED -> Sound.ENTITY_EXPERIENCE_ORB_PICKUP;
            case InteractionResult.State.REMOVED -> Sound.BLOCK_LAVA_EXTINGUISH;
            case InteractionResult.State.FAILURE -> Sound.ENTITY_VILLAGER_NO;
            default -> Sound.BLOCK_NETHER_WOOD_HIT;
        };
    }
}

