/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.helpers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import nl.gjorgdy.pl3xmarkers.core.MarkersConfig;
import nl.gjorgdy.pl3xmarkers.core.interfaces.entities.IPoint;

public class ConvexHull {
    private ConvexHull() {
    }

    private static int getMaxSize() {
        return MarkersConfig.AREA_MARKERS_MAX_SIZE;
    }

    private static int getMaxRadius() {
        return ConvexHull.getMaxSize() / 2;
    }

    public static List<IPoint> calculate(List<IPoint> points) {
        if (points.isEmpty()) {
            return points;
        }
        if (points.size() < 3) {
            return ConvexHull.minimalArea(points.getFirst());
        }
        points.sort(null);
        if (points.getFirst().distance(points.getLast()) > (double)ConvexHull.getMaxSize()) {
            points = ConvexHull.cluster(points);
        }
        return points.size() < 3 ? ConvexHull.minimalArea(points.getFirst()) : ConvexHull.calculateInternal(points);
    }

    private static List<IPoint> cluster(List<IPoint> points) {
        int centerX = points.stream().map(IPoint::getX).reduce(0, Integer::sum) / points.size();
        int centerZ = points.stream().map(IPoint::getZ).reduce(0, Integer::sum) / points.size();
        IPoint center = points.getFirst().set(centerX, centerZ);
        IPoint furthest = points.stream().max(Comparator.comparing(p -> p.distance(center))).orElse(points.getLast());
        if (furthest.distance(center) <= (double)ConvexHull.getMaxRadius()) {
            return points;
        }
        points.remove(furthest);
        return ConvexHull.cluster(points);
    }

    private static List<IPoint> calculateInternal(List<IPoint> points) {
        ArrayList<IPoint> lower = new ArrayList<IPoint>();
        for (IPoint p : points) {
            while (lower.size() >= 2 && ConvexHull.cross((IPoint)lower.get(lower.size() - 2), (IPoint)lower.getLast(), p) <= 0L) {
                lower.removeLast();
            }
            lower.add(p);
        }
        ArrayList<IPoint> upper = new ArrayList<IPoint>();
        for (int i = points.size() - 1; i >= 0; --i) {
            IPoint p = points.get(i);
            while (upper.size() >= 2 && ConvexHull.cross((IPoint)upper.get(upper.size() - 2), (IPoint)upper.getLast(), p) <= 0L) {
                upper.removeLast();
            }
            upper.add(p);
        }
        lower.removeLast();
        upper.removeLast();
        lower.addAll(upper);
        return lower;
    }

    private static List<IPoint> minimalArea(IPoint center) {
        return List.of(center.add(0, -8), center.add(8, 8), center.add(-8, 8));
    }

    private static long cross(IPoint a, IPoint b, IPoint c) {
        return (long)(b.getX() - a.getX()) * (long)(c.getZ() - a.getZ()) - (long)(b.getZ() - a.getZ()) * (long)(c.getX() - a.getX());
    }
}

