/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.json;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import nl.gjorgdy.pl3xmarkers.core.interfaces.IStorage;
import nl.gjorgdy.pl3xmarkers.core.json.repositories.AreaMarkerRepository;
import nl.gjorgdy.pl3xmarkers.core.json.repositories.IconMarkerRepository;

public class JsonStorage
implements IStorage {
    private IconMarkerRepository iconMarkerRepository;
    private AreaMarkerRepository areaMarkerRepository;
    private boolean loaded = false;

    private void load() {
        String configPath;
        String string = configPath = Pl3xMarkersCore.isBukkit() ? "plugins/Pl3xMarkers" : "config/pl3xmarkers";
        if (Pl3xMarkersCore.isBukkit()) {
            this.migrate(Path.of("config/pl3xmarkers", new String[0]), Path.of("plugins/Pl3xMarkers", new String[0]));
        }
        this.iconMarkerRepository = new IconMarkerRepository(configPath + "/markers", "icons");
        this.areaMarkerRepository = new AreaMarkerRepository(configPath + "/markers", "areas");
        this.loaded = true;
    }

    public AreaMarkerRepository getAreaMarkerRepository() {
        if (!this.loaded) {
            this.load();
        }
        return this.areaMarkerRepository;
    }

    public IconMarkerRepository getIconMarkerRepository() {
        if (!this.loaded) {
            this.load();
        }
        return this.iconMarkerRepository;
    }

    @Override
    public void close() {
        this.writeInternal();
    }

    public void write() {
        this.writeInternal();
    }

    private void writeInternal() {
        if (!this.loaded) {
            this.load();
        }
        this.iconMarkerRepository.write();
        this.areaMarkerRepository.write();
    }

    private void migrate(Path oldPath, Path newPath) {
        try (Stream<Path> files = Files.list(oldPath);){
            if (!Files.exists(newPath, new LinkOption[0])) {
                Files.createDirectories(newPath, new FileAttribute[0]);
            }
            files.forEach(oldFile -> {
                try {
                    Files.move(oldFile, newPath.resolve(oldFile.getFileName()), new CopyOption[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            Files.delete(oldPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

