/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.json.entities;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import nl.gjorgdy.pl3xmarkers.core.interfaces.entities.IAreaMarker;
import nl.gjorgdy.pl3xmarkers.core.interfaces.entities.IPoint;
import nl.gjorgdy.pl3xmarkers.core.json.entities.Point;
import nl.gjorgdy.pl3xmarkers.core.json.repositories.AreaMarkerRepository;

public class AreaMarker
implements IAreaMarker {
    private transient AreaMarkerRepository repository;
    private transient String world;
    private final String name;
    private final int color;
    private final Set<Point> points;

    public AreaMarker(AreaMarkerRepository areaMarkerRepository, String worldIdentifier, String name, int color) {
        this.repository = areaMarkerRepository;
        this.world = worldIdentifier;
        this.name = name;
        this.color = color;
        this.points = new HashSet<Point>();
    }

    public void setContext(AreaMarkerRepository repository, String worldIdentifier) {
        if (this.repository == null) {
            this.repository = repository;
        }
        if (this.world == null) {
            this.world = worldIdentifier;
        }
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public Collection<? extends IPoint> getPoints() {
        return this.points;
    }

    @Override
    public boolean addPoint(int x, int z) {
        boolean added = this.points.add(new Point(x, z));
        this.repository.markDirty();
        return added;
    }

    @Override
    public boolean removePoint(int x, int z) {
        boolean removed = this.points.removeIf(p -> p.getX() == x && p.getZ() == z);
        if (this.points.isEmpty()) {
            removed = removed && this.repository.removeArea(this);
        }
        this.repository.markDirty();
        return removed;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AreaMarker that = (AreaMarker)o;
        return this.color == that.color && Objects.equals(this.world, that.world) && Objects.equals(this.name, that.name) && Objects.equals(this.points, that.points);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.name, this.color, this.points);
    }
}

