/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.json.repositories;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import nl.gjorgdy.pl3xmarkers.core.interfaces.IAreaMarkerRepository;
import nl.gjorgdy.pl3xmarkers.core.json.entities.AreaMarker;
import nl.gjorgdy.pl3xmarkers.core.json.interfaces.IJsonRepositoryData;
import nl.gjorgdy.pl3xmarkers.core.json.repositories.JsonRepository;

public class AreaMarkerRepository
extends JsonRepository<Data>
implements IAreaMarkerRepository<AreaMarker> {
    public AreaMarkerRepository(String folderPath, String fileName) {
        super(folderPath, fileName, Data.class, new Data());
    }

    @Override
    public Collection<AreaMarker> getAreas(String worldIdentifier) {
        WorldData area = (WorldData)((Data)this.data).get(worldIdentifier);
        return area != null ? area : Set.of();
    }

    @Override
    public AreaMarker getArea(String worldIdentifier, String name, int color) {
        WorldData area = (WorldData)((Data)this.data).get(worldIdentifier);
        return area != null ? area.findFirst(name, color) : null;
    }

    @Override
    public AreaMarker getOrCreateArea(String worldIdentifier, String name, int color) {
        AreaMarker marker = ((Data)this.data).getOrCreate(worldIdentifier).findFirst(name, color);
        if (marker == null) {
            marker = new AreaMarker(this, worldIdentifier, name, color);
            this.getAreas(worldIdentifier).add(marker);
            this.markDirty();
        }
        return marker;
    }

    @Override
    public boolean removeArea(String worldIdentifier, String name, int color) {
        boolean removed = ((Data)this.data).getOrCreate(worldIdentifier).remove(name, color);
        if (removed) {
            this.markDirty();
        }
        return removed;
    }

    public boolean removeArea(AreaMarker areaMarker) {
        boolean removed = this.getAreas(areaMarker.getWorld()).remove(areaMarker);
        if (removed) {
            this.markDirty();
        }
        return removed;
    }

    public static class Data
    extends HashMap<String, WorldData>
    implements IJsonRepositoryData {
        public WorldData getOrCreate(String key) {
            return super.computeIfAbsent(key, k -> new WorldData());
        }

        @Override
        public void strip() {
            this.entrySet().removeIf(e -> ((WorldData)e.getValue()).isEmpty());
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() || super.values().stream().allMatch(Set::isEmpty);
        }

        @Override
        public void setContext(JsonRepository<?> jsonRepository) {
            this.forEach((worldIdentifier, world) -> world.setContext(jsonRepository, (String)worldIdentifier));
        }
    }

    public static class WorldData
    extends HashSet<AreaMarker> {
        public AreaMarker findFirst(String name, int color) {
            return this.stream().filter(m -> m.getName().equals(name) && m.getColor() == color).findFirst().orElse(null);
        }

        public boolean remove(String name, int color) {
            return this.removeIf(m -> m.getName().equals(name) && m.getColor() == color);
        }

        public void setContext(JsonRepository<?> jsonRepository, String worldIdentifier) {
            this.forEach(m -> m.setContext((AreaMarkerRepository)jsonRepository, worldIdentifier));
        }
    }
}

