/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.layers;

import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.core.MarkersConfig;
import nl.gjorgdy.pl3xmarkers.core.helpers.HtmlHelper;
import nl.gjorgdy.pl3xmarkers.core.helpers.WorldHelpers;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.IconMarkerLayer;
import nl.gjorgdy.pl3xmarkers.core.markers.IconMarkerBuilder;
import nl.gjorgdy.pl3xmarkers.core.registries.Layers;
import org.jetbrains.annotations.NotNull;

public class NetherPortalIconMarkerLayer
extends IconMarkerLayer {
    public NetherPortalIconMarkerLayer(@NotNull World world) {
        super("nether_portal", Layers.Keys.NETHER_PORTALS, Layers.Labels.NETHER_PORTALS, Layers.Tooltips.NETHER_PORTALS, world, MarkersConfig.NETHER_PORTAL_MARKERS_PRIORITY);
    }

    @Override
    protected Marker<?> createIconMarker(int x, int z) {
        String worldKey = this.getWorld().getKey();
        boolean isOverworld = WorldHelpers.isOverworld(worldKey);
        int relativeX = isOverworld ? x / 8 : x * 8;
        int relativeZ = isOverworld ? z / 8 : z * 8;
        return IconMarkerBuilder.newIconMarker(this.toMarkerKey(x, z), this.iconId, x, z).centerIcon(16, 16).addPopup(HtmlHelper.TravelPopUp(this.tooltip, this.destinationKey(worldKey), relativeX, relativeZ, this.buttonText(worldKey))).build();
    }

    private String buttonText(String worldKey) {
        return WorldHelpers.isOverworld(worldKey) ? "Go to Nether" : "Go to Overworld";
    }

    private String destinationKey(String worldKey) {
        return switch (worldKey) {
            case "minecraft:the_nether" -> "minecraft-overworld";
            case "minecraft:overworld" -> "minecraft-the_nether";
            case "world" -> "world_nether";
            case "world_nether" -> "world";
            default -> this.dynamicDestinationKey(worldKey);
        };
    }

    private String dynamicDestinationKey(String worldKey) {
        Object destination = WorldHelpers.isOverworld(worldKey) ? worldKey + "_nether" : worldKey.replace("_nether", "");
        return ((String)destination).replace(":", "-");
    }
}

