/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.layers.primitive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import nl.gjorgdy.pl3xmarkers.core.helpers.ConvexHull;
import nl.gjorgdy.pl3xmarkers.core.helpers.HtmlHelper;
import nl.gjorgdy.pl3xmarkers.core.interfaces.entities.IAreaMarker;
import nl.gjorgdy.pl3xmarkers.core.interfaces.entities.IPoint;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.MarkerLayer;
import nl.gjorgdy.pl3xmarkers.core.markers.AreaMarkerBuilder;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class AreaMarkerLayer
extends MarkerLayer {
    public AreaMarkerLayer(String key, String label, @NotNull World world, int priority) {
        super(key, label, world, priority);
    }

    @Override
    public void load() {
        Pl3xMarkersCore.storage().getAreaMarkerRepository().getAreas(this.worldIdentifier).forEach(this::loadArea);
    }

    public void loadArea(IAreaMarker area) {
        Collection<? extends IPoint> points;
        if (super.hasMarker(area.getKey())) {
            super.removeMarker(area.getKey());
        }
        if ((points = area.getPoints()) == null || points.isEmpty()) {
            return;
        }
        List<IPoint> sortedPoints = ConvexHull.calculate(new ArrayList<IPoint>(area.getPoints()));
        if (!sortedPoints.isEmpty()) {
            super.addMarker(AreaMarkerBuilder.newAreaMarker(area.getKey(), sortedPoints).fill(area.getColor()).stroke(area.getColor()).addPopup(HtmlHelper.sanitize(area.getName())));
        }
    }

    public boolean addPoint(@Language(value="HTML") String label, int color, int x, int z) {
        IAreaMarker area = Pl3xMarkersCore.storage().getAreaMarkerRepository().getOrCreateArea(this.worldIdentifier, label, color);
        if (area.addPoint(x, z)) {
            Pl3xMarkersCore.runParallel(() -> this.loadArea(area));
            return true;
        }
        return false;
    }

    public boolean removePoint(@Language(value="HTML") String label, int color, int x, int z) {
        IAreaMarker area = Pl3xMarkersCore.storage().getAreaMarkerRepository().getArea(this.worldIdentifier, label, color);
        if (area != null && area.removePoint(x, z)) {
            Pl3xMarkersCore.runParallel(() -> this.loadArea(area));
            return true;
        }
        return false;
    }
}

