/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.fabric;

import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import nl.gjorgdy.pl3xmarkers.core.json.JsonStorage;
import nl.gjorgdy.pl3xmarkers.core.registries.Layers;
import nl.gjorgdy.pl3xmarkers.fabric.FabricMarkersConfig;
import nl.gjorgdy.pl3xmarkers.fabric.compat.layers.OPACAreaMarkerLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pl3xMarkersFabric
implements DedicatedServerModInitializer {
    public static Logger LOGGER = LoggerFactory.getLogger(Pl3xMarkersCore.class);

    public static boolean isOpacInstalled() {
        return FabricLoader.getInstance().isModLoaded("openpartiesandclaims");
    }

    public static boolean isOpacEnabled() {
        return Pl3xMarkersFabric.isOpacInstalled() && FabricMarkersConfig.OPAC_MARKERS_ENABLED;
    }

    public void onInitializeServer() {
        if (Pl3xMarkersFabric.isOpacInstalled()) {
            Layers.register(OPACAreaMarkerLayer::new, unused -> Pl3xMarkersFabric.isOpacEnabled());
        }
        JsonStorage storage = new JsonStorage();
        Pl3xMarkersCore.onInitialize(false, storage, FabricMarkersConfig::reload);
        ServerLifecycleEvents.AFTER_SAVE.register((server, flush, force) -> storage.write());
        ServerLifecycleEvents.SERVER_STARTING.register(unused -> Pl3xMarkersCore.onStarted());
        ServerLifecycleEvents.SERVER_STOPPED.register(unused -> Pl3xMarkersCore.onDisable());
    }
}

