/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.fabric.compat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import nl.gjorgdy.pl3xmarkers.fabric.Pl3xMarkersFabric;
import nl.gjorgdy.pl3xmarkers.fabric.compat.OpacChunk;
import nl.gjorgdy.pl3xmarkers.fabric.compat.OpacListener;
import nl.gjorgdy.pl3xmarkers.fabric.compat.layers.OPACAreaMarkerLayer;
import xaero.pac.common.claims.player.api.IPlayerDimensionClaimsAPI;
import xaero.pac.common.claims.tracker.api.IClaimsManagerListenerAPI;
import xaero.pac.common.server.api.OpenPACServerAPI;
import xaero.pac.common.server.claims.ServerClaimsManager;
import xaero.pac.common.server.claims.api.IServerClaimsManagerAPI;
import xaero.pac.common.server.claims.player.api.IServerPlayerClaimInfoAPI;

public class OpacHandler {
    public static boolean isOpacLoaded(MinecraftServer server) {
        ServerClaimsManager scm;
        IServerClaimsManagerAPI iServerClaimsManagerAPI;
        return Pl3xMarkersFabric.isOpacEnabled() && (iServerClaimsManagerAPI = OpenPACServerAPI.get((MinecraftServer)server).getServerClaimsManager()) instanceof ServerClaimsManager && (scm = (ServerClaimsManager)iServerClaimsManagerAPI).isLoaded();
    }

    public static void registerListener(MinecraftServer server, OPACAreaMarkerLayer markerLayer) {
        OpenPACServerAPI.get((MinecraftServer)server).getServerClaimsManager().getTracker().register((IClaimsManagerListenerAPI)new OpacListener(markerLayer));
    }

    public static Collection<OpacChunk> load(MinecraftServer server, String worldIdentifier) {
        HashSet<OpacChunk> chunks = new HashSet<OpacChunk>();
        OpenPACServerAPI.get((MinecraftServer)server).getServerClaimsManager().getPlayerInfoStream().forEach(p -> {
            IPlayerDimensionClaimsAPI dimensionManager = p.getDimension(class_2960.method_60654((String)worldIdentifier));
            if (dimensionManager == null) {
                return;
            }
            dimensionManager.getStream().forEach(claim -> claim.getStream().forEach(chunk -> chunks.add(new OpacChunk((class_1923)chunk, p.getPlayerUsername(), p.getClaimsName(), p.getClaimsColor()))));
        });
        return chunks;
    }

    public static Collection<OpacChunk> getClaimedChunks(MinecraftServer server, class_2960 world, UUID uuid) {
        IServerPlayerClaimInfoAPI playerInfo = OpenPACServerAPI.get((MinecraftServer)server).getServerClaimsManager().getPlayerInfo(uuid);
        IPlayerDimensionClaimsAPI pdc = playerInfo.getDimension(world);
        if (pdc == null) {
            return new ArrayList<OpacChunk>();
        }
        return pdc.getStream().flatMap(claim -> claim.getStream().map(chunk -> new OpacChunk((class_1923)chunk, playerInfo.getPlayerUsername(), playerInfo.getClaimsName(), playerInfo.getClaimsColor()))).toList();
    }

    public static OpacChunk getChunk(MinecraftServer server, UUID uuid, int x, int z) {
        IServerPlayerClaimInfoAPI playerInfo = OpenPACServerAPI.get((MinecraftServer)server).getServerClaimsManager().getPlayerInfo(uuid);
        return new OpacChunk(new class_1923(x, z), playerInfo.getPlayerUsername(), playerInfo.getClaimsName(), playerInfo.getClaimsColor());
    }
}

