/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.fabric.compat.layers;

import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.MarkerLayer;
import nl.gjorgdy.pl3xmarkers.core.markers.AreaMarkerBuilder;
import nl.gjorgdy.pl3xmarkers.core.markers.MarkerBuilder;
import nl.gjorgdy.pl3xmarkers.core.registries.Layers;
import nl.gjorgdy.pl3xmarkers.fabric.FabricMarkersConfig;
import nl.gjorgdy.pl3xmarkers.fabric.compat.OpacChunk;
import nl.gjorgdy.pl3xmarkers.fabric.compat.OpacHandler;
import org.jetbrains.annotations.NotNull;

public class OPACAreaMarkerLayer
extends MarkerLayer {
    public OPACAreaMarkerLayer(@NotNull World world) {
        super(Layers.Keys.OPAC, Layers.Labels.OPAC, world, FabricMarkersConfig.OPAC_MARKERS_PRIORITY);
    }

    @Override
    public void load() {
        Pl3xMarkersCore.runParallel(() -> {
            MinecraftServer server = this.getServer();
            while (!OpacHandler.isOpacLoaded(server)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            OpacHandler.load(server, this.worldIdentifier).forEach(this::addChunk);
        });
        OpacHandler.registerListener(this.getServer(), this);
    }

    public void addChunk(OpacChunk chunk) {
        this.addMarker(this.createAreaMarker(chunk));
    }

    private MarkerBuilder<?> createAreaMarker(OpacChunk chunk) {
        return AreaMarkerBuilder.newAreaMarker(chunk.getKey(), chunk.getCorners()).fill(chunk.color()).stroke(chunk.color()).addPopup(chunk.getName());
    }

    public final MinecraftServer getServer() {
        Object object = this.getWorld().getLevel();
        if (object instanceof class_3218) {
            class_3218 serverWorld = (class_3218)object;
            return serverWorld.method_8503();
        }
        throw new IllegalStateException("World is not a server world");
    }
}

