/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.markers.layer.Layer;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.Layers;
import nl.gjorgdy.pl3xmarkers.Pl3xMarkers;
import nl.gjorgdy.pl3xmarkers.layers.primitive.AreaMarkerLayer;
import nl.gjorgdy.pl3xmarkers.layers.primitive.IconMarkerLayer;
import nl.gjorgdy.pl3xmarkers.layers.primitive.MarkerLayer;
import org.intellij.lang.annotations.Language;

public class Api {
    public ExecutorService executor = new ThreadPoolExecutor(2, 8, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000));

    private static World getWorld(class_2960 worldIdentifier) {
        World world = (World)Pl3xMap.api().getWorldRegistry().get(worldIdentifier.toString());
        if (world == null) {
            throw new RuntimeException("World not found " + String.valueOf(worldIdentifier));
        }
        return world;
    }

    public void registerMarkerLayer(Function<World, MarkerLayer> function) {
        Pl3xMarkers.pl3xHandler().registerMarkerLayer(function);
    }

    public void registerIconImage(String path, String filename, String filetype) {
        Pl3xMarkers.pl3xHandler().registerIconImage(path, filename, filetype);
    }

    public void addAreaPoint(class_2960 worldIdentifier, @Language(value="HTML") String label, int color, class_2338 pos) {
        this.executor.execute(() -> {
            Layer layer = (Layer)Api.getWorld(worldIdentifier).getLayerRegistry().get(Layers.Keys.AREAS);
            if (layer instanceof AreaMarkerLayer) {
                AreaMarkerLayer aml = (AreaMarkerLayer)layer;
                aml.addPoint(label, color, pos.method_10263(), pos.method_10260());
            }
        });
    }

    public void removeAreaPoint(class_2960 worldIdentifier, @Language(value="HTML") String label, int color, class_2338 pos) {
        this.executor.execute(() -> {
            Layer layer = (Layer)Api.getWorld(worldIdentifier).getLayerRegistry().get(Layers.Keys.AREAS);
            if (layer instanceof AreaMarkerLayer) {
                AreaMarkerLayer aml = (AreaMarkerLayer)layer;
                aml.removePoint(label, color, pos.method_10263(), pos.method_10260());
            }
        });
    }

    public void addNetherPortalIconMarker(class_2960 worldIdentifier, class_2338 pos) {
        this.addIconMarker(worldIdentifier, Layers.Keys.NETHER_PORTALS, pos);
    }

    public void addEndGatewayIconMarker(class_2960 worldIdentifier, class_2338 pos) {
        this.addIconMarker(worldIdentifier, Layers.Keys.END_GATEWAYS, pos);
    }

    public void addEndPortalIconMarker(class_2960 worldIdentifier, class_2338 pos) {
        this.addIconMarker(worldIdentifier, Layers.Keys.END_PORTALS, pos);
    }

    public void addBeaconIconMarker(class_2960 worldIdentifier, class_2338 pos) {
        this.addIconMarker(worldIdentifier, Layers.Keys.BEACONS, pos);
    }

    public void addIconMarker(class_2960 worldIdentifier, String layerKey, class_2338 pos) {
        this.executor.execute(() -> {
            Layer layer = (Layer)Api.getWorld(worldIdentifier).getLayerRegistry().get(layerKey);
            if (layer instanceof IconMarkerLayer) {
                IconMarkerLayer simpleIconMarkerLayer = (IconMarkerLayer)layer;
                simpleIconMarkerLayer.addSimpleMarker(pos);
            }
        });
    }

    public void removeNetherPortalIconMarker(class_2960 worldIdentifier, class_2338 pos) {
        this.removeIconMarker(worldIdentifier, Layers.Keys.NETHER_PORTALS, pos);
    }

    public void removeEndGatewayIconMarker(class_2960 worldIdentifier, class_2338 pos) {
        this.removeIconMarker(worldIdentifier, Layers.Keys.END_GATEWAYS, pos);
    }

    public void removeEndPortalIconMarker(class_2960 worldIdentifier, class_2338 pos) {
        this.removeIconMarker(worldIdentifier, Layers.Keys.END_PORTALS, pos);
    }

    public void removeBeaconIconMarker(class_2960 worldIdentifier, class_2338 pos) {
        this.removeIconMarker(worldIdentifier, Layers.Keys.BEACONS, pos);
    }

    public void removeIconMarker(class_2960 worldIdentifier, String layerKey, class_2338 pos) {
        this.executor.execute(() -> {
            Layer layer = (Layer)Api.getWorld(worldIdentifier).getLayerRegistry().get(layerKey);
            if (layer instanceof IconMarkerLayer) {
                IconMarkerLayer markerLayer = (IconMarkerLayer)layer;
                markerLayer.removeMarker(pos);
            }
        });
    }
}

