/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.helpers;

import java.util.ArrayList;
import java.util.List;
import nl.gjorgdy.pl3xmarkers.entities.AreaPointEntity;

public class ConvexHull {
    private static final int maxDistance = 128;

    private ConvexHull() {
    }

    public static List<AreaPointEntity> calculate(List<AreaPointEntity> points) {
        if (points.size() <= 1) {
            return new ArrayList<AreaPointEntity>(points);
        }
        points.sort(null);
        ArrayList<AreaPointEntity> lower = new ArrayList<AreaPointEntity>();
        for (AreaPointEntity p : points) {
            while (lower.size() >= 2 && ConvexHull.cross((AreaPointEntity)lower.get(lower.size() - 2), (AreaPointEntity)lower.getLast(), p) <= 0L) {
                lower.removeLast();
            }
            if (!lower.isEmpty() && !(((AreaPointEntity)lower.getLast()).distance(p) <= 128.0)) continue;
            lower.add(p);
        }
        ArrayList<AreaPointEntity> upper = new ArrayList<AreaPointEntity>();
        for (int i = points.size() - 1; i >= 0; --i) {
            AreaPointEntity p = points.get(i);
            while (upper.size() >= 2 && ConvexHull.cross((AreaPointEntity)upper.get(upper.size() - 2), (AreaPointEntity)upper.getLast(), p) <= 0L) {
                upper.removeLast();
            }
            if (!upper.isEmpty() && !(((AreaPointEntity)upper.getLast()).distance(p) <= 128.0)) continue;
            upper.add(p);
        }
        lower.removeLast();
        upper.removeLast();
        lower.addAll(upper);
        return lower;
    }

    private static long cross(AreaPointEntity a, AreaPointEntity b, AreaPointEntity c) {
        return (long)(b.getX() - a.getX()) * (long)(c.getZ() - a.getZ()) - (long)(b.getZ() - a.getZ()) * (long)(c.getX() - a.getX());
    }
}

