/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.layers;

import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.Layers;
import nl.gjorgdy.pl3xmarkers.helpers.HtmlHelper;
import nl.gjorgdy.pl3xmarkers.layers.primitive.IconMarkerLayer;
import nl.gjorgdy.pl3xmarkers.markers.IconMarkerBuilder;
import org.jetbrains.annotations.NotNull;

public class NetherPortalIconMarkerLayer
extends IconMarkerLayer {
    public NetherPortalIconMarkerLayer(@NotNull World world) {
        super("nether_portal", Layers.Keys.NETHER_PORTALS, Layers.Labels.NETHER_PORTALS, Layers.Tooltips.NETHER_PORTALS, world);
    }

    @Override
    public boolean isInWorld(@NotNull World world) {
        return this.isOverworld(world) || this.isNether(world);
    }

    @Override
    protected Marker<?> createIconMarker(int x, int z) {
        String worldKey = this.getWorld().getKey();
        boolean isOverworld = worldKey.equals("minecraft:overworld");
        String destinationKey = isOverworld ? "minecraft-the_nether" : "minecraft-overworld";
        int relativeX = isOverworld ? x / 8 : x * 8;
        int relativeZ = isOverworld ? z / 8 : z * 8;
        String buttonText = isOverworld ? "Go to Nether" : "Go to Overworld";
        return IconMarkerBuilder.newIconMarker(this.toMarkerKey(x, z), this.iconId, x, z).centerIcon(16, 16).addPopup(HtmlHelper.TravelPopUp(this.tooltip, destinationKey, relativeX, relativeZ, buttonText)).build();
    }
}

