/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.layers.primitive;

import net.minecraft.class_2338;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.Pl3xMarkers;
import nl.gjorgdy.pl3xmarkers.layers.primitive.MarkerLayer;
import nl.gjorgdy.pl3xmarkers.markers.IconMarkerBuilder;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class IconMarkerLayer
extends MarkerLayer {
    public final String iconId;
    public final String key;
    public final String label;
    @Language(value="HTML")
    public final String tooltip;

    public IconMarkerLayer(String icon, String key, String label, @Language(value="HTML") String tooltip, @NotNull World world) {
        super(key, label, world);
        this.iconId = icon;
        this.key = key;
        this.label = label;
        this.tooltip = tooltip;
    }

    @Override
    public void load() {
        Pl3xMarkers.iconMarkerRepository().getMarkers(this.getWorld().getKey(), this.key).forEach(marker -> this.addIconMarker(marker.getX(), marker.getZ()));
    }

    @Override
    public boolean isInWorld(@NotNull World world) {
        return true;
    }

    public void addSimpleMarker(class_2338 pos) {
        boolean added = Pl3xMarkers.iconMarkerRepository().addMarker(this.getWorld().getKey(), this.key, pos.method_10263(), pos.method_10260());
        if (added) {
            this.addIconMarker(pos.method_10263(), pos.method_10260());
        }
    }

    public void removeMarker(class_2338 pos) {
        Pl3xMarkers.iconMarkerRepository().removeMarker(this.getWorld().getKey(), this.key, pos.method_10263(), pos.method_10260());
        super.removeMarker(this.toMarkerKey(pos.method_10263(), pos.method_10260()));
    }

    private void addIconMarker(int x, int z) {
        this.addMarker(this.createIconMarker(x, z));
    }

    protected Marker<?> createIconMarker(int x, int z) {
        return IconMarkerBuilder.newIconMarker(this.toMarkerKey(x, z), this.iconId, x, z).centerIcon(16, 16).addTooltip(this.tooltip).build();
    }
}

