/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.markers;

import java.util.List;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Polygon;
import net.pl3x.map.core.markers.marker.Polyline;
import net.pl3x.map.core.markers.option.Fill;
import net.pl3x.map.core.markers.option.Stroke;
import nl.gjorgdy.pl3xmarkers.entities.AreaPointEntity;
import nl.gjorgdy.pl3xmarkers.helpers.ConvexHull;
import nl.gjorgdy.pl3xmarkers.markers.MarkerBuilder;
import org.jetbrains.annotations.NotNull;

public class AreaMarkerBuilder
extends MarkerBuilder<Polygon> {
    private AreaMarkerBuilder(Marker<@NotNull Polygon> marker) {
        super(marker);
    }

    public static AreaMarkerBuilder newAreaMarker(String key, List<AreaPointEntity> points) {
        Polyline line = new Polyline(key, new Point[0]);
        for (AreaPointEntity point : ConvexHull.calculate(points)) {
            line.addPoint(point.toPl3xPoint());
        }
        Polygon area = new Polygon(key, line);
        return new AreaMarkerBuilder((Marker<Polygon>)area);
    }

    public AreaMarkerBuilder fill(int color) {
        return this.fill(color, 64);
    }

    public AreaMarkerBuilder fill(int color, int alpha) {
        this.options.setFill(new Fill(AreaMarkerBuilder.setAlpha(color, alpha)).setEnabled(Boolean.valueOf(true)));
        return this;
    }

    public AreaMarkerBuilder stroke(int color) {
        return this.stroke(color, 2);
    }

    public AreaMarkerBuilder stroke(int color, int weight) {
        this.options.setStroke(new Stroke(weight, color));
        return this;
    }

    public static int setAlpha(int color, int alpha) {
        return color & 0xFFFFFF | (alpha &= 0xFF) << 24;
    }
}

