/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.repositories;

import com.j256.ormlite.stmt.DeleteBuilder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nl.gjorgdy.pl3xmarkers.Database;
import nl.gjorgdy.pl3xmarkers.Pl3xMarkers;
import nl.gjorgdy.pl3xmarkers.entities.IconMarkerEntity;

public class IconMarkerRepository {
    private final Database database;

    public IconMarkerRepository(Database database) {
        this.database = database;
    }

    public List<IconMarkerEntity> getMarkers(String worldKey, String layerKey) {
        try {
            return this.database.markers.queryBuilder().where().eq("world", (Object)worldKey).and().eq("layer", (Object)layerKey).query();
        }
        catch (Exception e) {
            Pl3xMarkers.LOGGER.error(e.getMessage());
            return new ArrayList<IconMarkerEntity>();
        }
    }

    public boolean addMarker(String worldKey, String layerKey, int x, int z) {
        try {
            IconMarkerEntity marker = new IconMarkerEntity(worldKey, layerKey, x, z);
            return this.database.markers.create((Object)marker) > 0;
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 0) {
                Pl3xMarkers.LOGGER.error("[{}] {}", (Object)e.getErrorCode(), (Object)e.getCause().getMessage());
            }
            return false;
        }
    }

    public void removeMarker(String worldKey, String layerKey, int x, int z) {
        try {
            DeleteBuilder deleteBuilder = this.database.markers.deleteBuilder();
            deleteBuilder.where().eq("world", (Object)worldKey).and().eq("layer", (Object)layerKey).and().eq("x", (Object)x).and().eq("z", (Object)z);
            deleteBuilder.delete();
        }
        catch (Exception e) {
            Pl3xMarkers.LOGGER.error(e.getMessage());
        }
    }
}

