/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.layers;

import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.core.Layers;
import nl.gjorgdy.pl3xmarkers.core.helpers.HtmlHelper;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.IconMarkerLayer;
import nl.gjorgdy.pl3xmarkers.core.markers.IconMarkerBuilder;
import org.jetbrains.annotations.NotNull;

public class NetherPortalIconMarkerLayer
extends IconMarkerLayer {
    public NetherPortalIconMarkerLayer(@NotNull World world) {
        super("nether_portal", Layers.Keys.NETHER_PORTALS, Layers.Labels.NETHER_PORTALS, Layers.Tooltips.NETHER_PORTALS, world);
    }

    @Override
    public boolean isInWorld(@NotNull World world) {
        return this.isOverworld(world) || this.isNether(world);
    }

    @Override
    protected Marker<?> createIconMarker(int x, int z) {
        String worldKey = this.getWorld().getKey();
        boolean isOverworld = this.isOverworld(worldKey);
        int relativeX = isOverworld ? x / 8 : x * 8;
        int relativeZ = isOverworld ? z / 8 : z * 8;
        return IconMarkerBuilder.newIconMarker(this.toMarkerKey(x, z), this.iconId, x, z).centerIcon(16, 16).addPopup(HtmlHelper.TravelPopUp(this.tooltip, this.destinationKey(worldKey), relativeX, relativeZ, this.buttonText(worldKey))).build();
    }

    private String buttonText(String worldKey) {
        return this.isOverworld(worldKey) ? "Go to Nether" : "Go to Overworld";
    }

    private String destinationKey(String worldKey) {
        return switch (worldKey) {
            case "minecraft:the_nether" -> "minecraft-overworld";
            case "minecraft:overworld" -> "minecraft-the_nether";
            case "world" -> "world_nether";
            case "world_nether" -> "world";
            default -> throw new IllegalStateException("Unexpected value: " + worldKey);
        };
    }

    private boolean isOverworld(String worldKey) {
        return worldKey.equals("minecraft:overworld") || worldKey.equals("world");
    }
}

