/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.repositories;

import com.j256.ormlite.dao.ForeignCollection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nl.gjorgdy.pl3xmarkers.core.Database;
import nl.gjorgdy.pl3xmarkers.core.entities.AreaEntity;
import nl.gjorgdy.pl3xmarkers.core.entities.AreaPointEntity;
import org.jetbrains.annotations.Nullable;

public class AreaRepository {
    private final Database database;

    public AreaRepository(Database database) {
        this.database = database;
    }

    public List<AreaEntity> getAreas(String world) {
        try {
            return this.database.areas.queryBuilder().where().eq("world", world).query();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
            return new ArrayList<AreaEntity>();
        }
    }

    @Nullable
    public AreaEntity getArea(String world, String label, int color) {
        try {
            return (AreaEntity)this.database.areas.queryBuilder().where().eq("world", world).and().eq("label", label).and().eq("color", color).queryForFirst();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public AreaEntity getOrCreateArea(String world, String label, int color) {
        AreaEntity area = this.getArea(world, label, color);
        if (area == null) {
            area = new AreaEntity(world, label, color);
            try {
                this.database.areas.create(area);
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
                return null;
            }
        }
        return area;
    }

    public boolean addPoint(String world, String label, int color, int x, int z) {
        AreaEntity area = this.getOrCreateArea(world, label, color);
        if (area == null) {
            return false;
        }
        ForeignCollection<AreaPointEntity> points = area.getPoints();
        if (points == null) {
            return false;
        }
        return points.add(new AreaPointEntity(area, x, z));
    }

    public boolean removePoint(String world, String label, int color, int x, int z) {
        AreaEntity area = this.getOrCreateArea(world, label, color);
        if (area == null) {
            return false;
        }
        ForeignCollection<AreaPointEntity> points = area.getPoints();
        if (points == null) {
            return false;
        }
        return points.removeIf(p -> p.getX() == x && p.getZ() == z);
    }
}

