package net.dragon.jsonmodel;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import net.dragon.jsonmodel.BlockJsonModelBake.BakedQuad;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.*;

public class JsonBlock {
  public static final Table<String, String, IIcon> iconMap = HashBasedTable.create();
  public static final Table<String, String, String> iconNameMap = HashBasedTable.create();
  public static final Map<IBlockJsonModel, Integer> IDMap = new HashMap<>();
  public static final Gson gson = new Gson();
  public static int jsonID = 80000;
  public static List<RenderRequest> renderRequest = new ArrayList<>();

  public static void register(final IBlockJsonModel block, boolean randomRotation, boolean renderItem,
                              boolean autoRotationY, int rotation, String... name) {
    Objects.requireNonNull(block);
    if (FMLLaunchHandler.side().isServer()) {
      IDMap.put(block, jsonID);
      jsonID++;
      return;
    }

    String modId = Loader.instance().activeModContainer().getModId();
    if (Objects.isNull(modId) || modId.isEmpty()) {
      modId = "minecraft";
    }

    int size = name.length;
    ModelJson[] models = new ModelJson[size];
    for (int s = 0; s < size; s++) {
      ModMain.LOGGER.info("register json block model : {}", name[s]);
      final String path = String.format("assets/%s/textures/json/block/%s.json", modId, name[s]);

      try (final InputStream stream = JsonBlock.class.getClassLoader().getResourceAsStream(path)) {
        if (Objects.isNull(stream)) {
          continue;
        }

        final InputStreamReader reader = new InputStreamReader(stream);
        models[s] = gson.fromJson(reader, ModelJson.class);
        if (Objects.isNull(models[s]) || Objects.isNull(models[s].textures)) {
          continue;
        }

        final String resourceName = modId + ":" + name[s];
        models[s].textures.forEach((textureID, textureName) -> {
          final String texName = textureName.replace("blocks/", "");
          iconNameMap.put(resourceName, textureID, texName);
          ModMain.LOGGER.info("Register texture for model: {}, ID : {} name : {}",
              resourceName,
              textureID,
              texName
          );
        });
      } catch (JsonSyntaxException | JsonIOException | IOException e) {
        ModMain.LOGGER.error(e);
      }
    }
    renderRequest.add(new RenderRequest(modId, jsonID, name, models, autoRotationY,
        false, rotation, randomRotation, renderItem));
    IDMap.put(block, jsonID);
    jsonID++;
  }

  protected static void registerJsonBlock(RenderRequest rr) {
    int size = rr.models.length;

    Map<String, IIcon> iconMapTemp = new HashMap<>();
    ModelJson modelJson;
    for (int s = 0; s < size; s++) {
      modelJson = rr.models[s];
      if (Objects.isNull(modelJson.textures)) {
        continue;
      }

      final String modelName = rr.modId + ":" + rr.name[s];
      modelJson.textures.forEach((textureID, textureName) -> {
        if (iconMap.contains(modelName, textureID)) {
          iconMapTemp.put(textureID, iconMap.get(modelName, textureID));
          return;
        }

        ModMain.LOGGER.error("Unable get texture for model: {}, ID : {} name : {}",
            modelName,
            textureID,
            textureName
        );
      });
    }

    List<List<BakedQuad>> quads = Lists.newArrayList();
    for (int s = 0; s < size; s++) {
      List<BakedQuad> bakedQuadsTemp = new ArrayList<>();
      for (ModelJson.Element e : rr.models[s].elements) {
        bakedQuadsTemp.addAll(BlockJsonModelBake.bakeElement(e, iconMapTemp));
      }
      quads.add(s, bakedQuadsTemp);
    }
    RenderingRegistry.registerBlockHandler(rr.ID, new RenderJsonBlockModel(quads, rr.ID,
        rr.autoRotationY, rr.autoOverlay, rr.rotation, rr.randomRotation, rr.renderItem));
  }

  public static void event() {
    for (RenderRequest request : renderRequest) {
      registerJsonBlock(request);
    }
  }
}
