package net.dragon.jsonmodel;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;

@Mod(modid = "jsonmodel", acceptableRemoteVersions = "*")
public class ModMain {
  public static final Logger LOGGER = LogManager.getLogger("JsonModel");

  @EventHandler
  public void preInit(FMLPreInitializationEvent event) {
    MinecraftForge.EVENT_BUS.register(this);
  }

  @SubscribeEvent
  public void onTextureStitchPre(TextureStitchEvent.Pre event) {
    for (Entry<String, Map<String, String>> entry : JsonBlock.iconNameMap.rowMap().entrySet()) {
      final String model = entry.getKey();
      final Map<String, String> textures = entry.getValue();

      textures.forEach((textureID, textureName) -> {
        final IIcon icon = event.map.registerIcon(textureName);
        JsonBlock.iconMap.put(model, textureID, icon);
        LOGGER.info("Success register icon {} for model {}, ID: {}", textureName, model, textureID);
      });
    }
  }

  @SubscribeEvent
  public void onTextureStitchPost(TextureStitchEvent.Post event) {
    if (event.map.getTextureType() == 0) {
      JsonBlock.event();
    }
  }
}
