/*
 * Decompiled with CFR 0.152.
 */
package net.dragon.jsonmodel;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dragon.jsonmodel.BlockJsonModelBake;
import net.dragon.jsonmodel.IBlockJsonModel;
import net.dragon.jsonmodel.ModMain;
import net.dragon.jsonmodel.ModelJson;
import net.dragon.jsonmodel.RenderJsonBlockModel;
import net.dragon.jsonmodel.RenderRequest;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IIcon;

public class JsonBlock {
    public static final Map<String, IIcon> iconMap = new HashMap<String, IIcon>();
    public static final Map<String, String> iconNameMap = new HashMap<String, String>();
    public static final Map<IBlockJsonModel, Integer> IDMap = new HashMap<IBlockJsonModel, Integer>();
    public static final Gson gson = new Gson();
    public static int jsonID = 90000;
    public static List<RenderRequest> renderRequest = new ArrayList<RenderRequest>();

    @SideOnly(value=Side.CLIENT)
    public static void register(IBlockJsonModel block, boolean randomRotation, boolean renderItem, boolean autoRotationY, int rotation, String ... name) {
        if (FMLLaunchHandler.side().isServer()) {
            throw new IllegalStateException("You can only register blocks model in client.");
        }
        Objects.requireNonNull(block);
        String modId = Loader.instance().activeModContainer().getModId();
        if (Objects.isNull(modId) || modId.isEmpty()) {
            modId = "minecraft";
        }
        int size = name.length;
        ModelJson[] models = new ModelJson[size];
        for (int s = 0; s < size; ++s) {
            ModMain.LOGGER.info("register json block model : {}", new Object[]{name[s]});
            Path path = Paths.get("assets", modId, "textures", "json", "block", name[s] + ".json");
            try (InputStream stream = JsonBlock.class.getResourceAsStream(path.toString());){
                if (Objects.isNull(stream)) continue;
                InputStreamReader reader = new InputStreamReader(stream);
                models[s] = (ModelJson)gson.fromJson((Reader)reader, ModelJson.class);
                if (Objects.isNull(models[s]) || Objects.isNull(models[s].textures)) continue;
                String finalModId = modId;
                models[s].textures.forEach((textureID, textureName) -> {
                    String texName = textureName.replace(finalModId + ":blocks/", "");
                    Minecraft.getMinecraft().getTextureMapBlocks().registerIcon(texName);
                    iconNameMap.put((String)textureID, texName);
                    ModMain.LOGGER.info("Register texture pool ID : {} name : {}", new Object[]{textureID, textureName});
                });
                continue;
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                ModMain.LOGGER.error((Object)e);
            }
        }
        renderRequest.add(new RenderRequest(jsonID, name, models, autoRotationY, false, rotation, randomRotation, renderItem));
        IDMap.put(block, jsonID);
        ++jsonID;
    }

    protected static void registerJsonBlock(RenderRequest RR) {
        int size = RR.models.length;
        HashMap<String, IIcon> iconMapTemp = new HashMap<String, IIcon>();
        for (int s = 0; s < size; ++s) {
            ModelJson MJ = RR.models[s];
            if (Objects.isNull(MJ.textures)) continue;
            MJ.textures.forEach((textureID, textureName) -> {
                if (iconMap.containsKey(textureID)) {
                    iconMapTemp.put((String)textureID, iconMap.get(textureID));
                } else {
                    ModMain.LOGGER.info("can't find texture from pool ID : {} name : {}", new Object[]{textureID, textureName});
                }
            });
        }
        ArrayList quads = Lists.newArrayList();
        for (int s = 0; s < size; ++s) {
            ArrayList<BlockJsonModelBake.BakedQuad> bakedQuadsTemp = new ArrayList<BlockJsonModelBake.BakedQuad>();
            for (ModelJson.Element e : RR.models[s].elements) {
                bakedQuadsTemp.addAll(BlockJsonModelBake.bakeElement(e, iconMapTemp));
            }
            quads.add(s, bakedQuadsTemp);
        }
        RenderingRegistry.registerBlockHandler((int)RR.ID, (ISimpleBlockRenderingHandler)new RenderJsonBlockModel(quads, RR.ID, RR.autoRotationY, RR.autoOverlay, RR.rotation, RR.randomRotation, RR.renderItem));
    }

    public static void event() {
        for (RenderRequest request : renderRequest) {
            JsonBlock.registerJsonBlock(request);
        }
    }
}

