/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client;

import com.moud.client.animation.AnimatedPlayerModel;
import com.moud.client.animation.ClientPlayerModelManager;
import com.moud.client.animation.ExternalPartConfigLayer;
import com.moud.client.animation.IAnimatedPlayer;
import com.moud.client.animation.PlayerModelRenderer;
import com.moud.client.animation.PlayerPartConfigManager;
import com.moud.client.api.service.ClientAPIService;
import com.moud.client.cursor.ClientCursorManager;
import com.moud.client.lighting.ClientLightingService;
import com.moud.client.movement.ClientMovementTracker;
import com.moud.client.network.ClientPacketReceiver;
import com.moud.client.network.ClientPacketWrapper;
import com.moud.client.network.DataPayload;
import com.moud.client.network.MoudPayload;
import com.moud.client.player.ClientCameraManager;
import com.moud.client.player.PlayerStateManager;
import com.moud.client.resources.InMemoryPackResources;
import com.moud.client.runtime.ClientScriptingRuntime;
import com.moud.client.shared.SharedValueManager;
import com.moud.client.ui.UIOverlayManager;
import com.moud.client.util.WindowAnimator;
import com.moud.network.MoudPackets;
import com.zigythebird.playeranim.api.PlayerAnimationAccess;
import com.zigythebird.playeranimcore.animation.layered.IAnimation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3281;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5352;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_7699;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MoudClientMod
implements ClientModInitializer,
class_3285 {
    public static final int PROTOCOL_VERSION = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoudClientMod.class);
    private static final class_2960 MOUDPACK_ID = class_2960.method_60655((String)"moud", (String)"dynamic_resources");
    private static final long JOIN_TIMEOUT_MS = 10000L;
    private static MoudClientMod instance;
    private static boolean customCameraActive;
    private final AtomicBoolean resourcesLoaded = new AtomicBoolean(false);
    private final AtomicBoolean waitingForResources = new AtomicBoolean(false);
    private final AtomicReference<InMemoryPackResources> dynamicPack = new AtomicReference<Object>(null);
    private PlayerModelRenderer playerModelRenderer;
    private ClientScriptingRuntime scriptingRuntime;
    private ClientAPIService apiService;
    private SharedValueManager sharedValueManager;
    private ClientCameraManager clientCameraManager;
    private PlayerStateManager playerStateManager;
    private ClientCursorManager clientCursorManager;
    private String currentResourcesHash = "";
    private long joinTime = -1L;
    private boolean moudServicesInitialized = false;
    private static boolean isOnMoudServer;

    public static boolean isCustomCameraActive() {
        return customCameraActive;
    }

    public static void setCustomCameraActive(boolean active) {
        customCameraActive = active;
    }

    public static MoudClientMod getInstance() {
        return instance;
    }

    public void onInitializeClient() {
        instance = this;
        LOGGER.info("Initializing Moud client...");
        PayloadTypeRegistry.playS2C().register(DataPayload.ID, DataPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(MoudPayload.ID, MoudPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(DataPayload.ID, DataPayload.CODEC);
        ClientPacketReceiver.registerS2CPackets();
        this.clientCursorManager = ClientCursorManager.getInstance();
        this.playerModelRenderer = new PlayerModelRenderer();
        this.registerPacketHandlers();
        this.registerEventHandlers();
        this.registerResourcePackProvider();
        this.registerTickHandler();
        this.registerRenderHandler();
        this.registerAnimationLayer();
        this.registerShutdownHandler();
        HudRenderCallback.EVENT.register((drawContext, tickCounter) -> {
            WindowAnimator.tick();
            if (this.scriptingRuntime != null && this.scriptingRuntime.isInitialized()) {
                this.scriptingRuntime.processAnimationFrameQueue();
            }
            if (this.apiService != null && this.apiService.events != null) {
                this.apiService.events.dispatch("render:hud", drawContext, Float.valueOf(tickCounter.method_60637(true)));
            }
            UIOverlayManager.getInstance().renderOverlays(drawContext, tickCounter);
        });
        LOGGER.info("Moud client initialization complete.");
    }

    private void registerPacketHandlers() {
        ClientPacketWrapper.registerHandler(MoudPackets.S2C_PlayPlayerAnimationPacket.class, (player, packet) -> this.handlePlayPlayerAnimation((MoudPackets.S2C_PlayPlayerAnimationPacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.S2C_PlayModelAnimationPacket.class, (player, packet) -> this.handlePlayModelAnimation((MoudPackets.S2C_PlayModelAnimationPacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.SyncClientScriptsPacket.class, (player, packet) -> this.handleSyncScripts((MoudPackets.SyncClientScriptsPacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.ClientboundScriptEventPacket.class, (player, packet) -> this.handleScriptEvent((MoudPackets.ClientboundScriptEventPacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.CameraLockPacket.class, (player, packet) -> this.handleCameraLock((MoudPackets.CameraLockPacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.PlayerStatePacket.class, (player, packet) -> this.handlePlayerState((MoudPackets.PlayerStatePacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.ExtendedPlayerStatePacket.class, (player, packet) -> this.handleExtendedPlayerState((MoudPackets.ExtendedPlayerStatePacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.SyncSharedValuesPacket.class, (player, packet) -> this.handleSharedValueSync((MoudPackets.SyncSharedValuesPacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.PlayerModelCreatePacket.class, (player, packet) -> this.handlePlayerModelCreate((MoudPackets.PlayerModelCreatePacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.PlayerModelUpdatePacket.class, (player, packet) -> this.handlePlayerModelUpdate((MoudPackets.PlayerModelUpdatePacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.PlayerModelSkinPacket.class, (player, packet) -> this.handlePlayerModelSkin((MoudPackets.PlayerModelSkinPacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.PlayerModelRemovePacket.class, (player, packet) -> this.handlePlayerModelRemove((MoudPackets.PlayerModelRemovePacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.AdvancedCameraLockPacket.class, (player, packet) -> this.handleAdvancedCameraLock((MoudPackets.AdvancedCameraLockPacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.CameraUpdatePacket.class, (player, packet) -> this.handleCameraUpdate((MoudPackets.CameraUpdatePacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.CameraReleasePacket.class, (player, packet) -> this.handleCameraRelease((MoudPackets.CameraReleasePacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.S2C_ManageWindowPacket.class, (player, packet) -> this.handleManageWindow((MoudPackets.S2C_ManageWindowPacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.S2C_TransitionWindowPacket.class, (player, packet) -> this.handleTransitionWindow((MoudPackets.S2C_TransitionWindowPacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.S2C_RestoreWindowPacket.class, (player, packet) -> class_310.method_1551().execute(() -> WindowAnimator.restore(packet.duration(), packet.easing())));
        ClientPacketWrapper.registerHandler(MoudPackets.S2C_WindowSequencePacket.class, (player, packet) -> class_310.method_1551().execute(() -> WindowAnimator.startSequence(packet.steps())));
        ClientPacketWrapper.registerHandler(MoudPackets.CursorPositionUpdatePacket.class, (player, packet) -> {
            if (this.clientCursorManager != null) {
                this.clientCursorManager.handlePositionUpdates(packet.updates());
            }
        });
        ClientPacketWrapper.registerHandler(MoudPackets.CursorAppearancePacket.class, (player, packet) -> {
            if (this.clientCursorManager != null) {
                this.clientCursorManager.handleAppearanceUpdate(packet.playerId(), packet.texture(), packet.color(), packet.scale(), packet.renderMode());
            }
        });
        ClientPacketWrapper.registerHandler(MoudPackets.CursorVisibilityPacket.class, (player, packet) -> {
            if (this.clientCursorManager != null) {
                this.clientCursorManager.handleVisibilityUpdate(packet.playerId(), packet.visible());
            }
        });
        ClientPacketWrapper.registerHandler(MoudPackets.RemoveCursorsPacket.class, (player, packet) -> {
            if (this.clientCursorManager != null) {
                this.clientCursorManager.handleRemoveCursors(packet.playerIds());
            }
        });
        ClientPacketWrapper.registerHandler(MoudPackets.S2C_SetPlayerPartConfigPacket.class, (player, packet) -> PlayerPartConfigManager.getInstance().updatePartConfig(packet.playerId(), packet.partName(), packet.properties()));
        ClientPacketWrapper.registerHandler(MoudPackets.InterpolationSettingsPacket.class, (player, packet) -> this.handleInterpolationSettings((MoudPackets.InterpolationSettingsPacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.FirstPersonConfigPacket.class, (player, packet) -> this.handleFirstPersonConfig((MoudPackets.FirstPersonConfigPacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.CameraControlPacket.class, (player, packet) -> this.handleCameraControl((MoudPackets.CameraControlPacket)packet));
        ClientPacketWrapper.registerHandler(MoudPackets.S2C_PlayModelAnimationWithFadePacket.class, (player, packet) -> class_310.method_1551().execute(() -> {
            AnimatedPlayerModel model = ClientPlayerModelManager.getInstance().getModel(packet.modelId());
            if (model != null) {
                model.playAnimationWithFade(packet.animationId(), packet.durationTicks());
                LOGGER.info("Playing animation '{}' with fade on model {}.", (Object)packet.animationId(), (Object)packet.modelId());
            } else {
                LOGGER.warn("Received faded animation for unknown model ID: {}", (Object)packet.modelId());
            }
        }));
        LOGGER.info("Internal packet handlers registered.");
    }

    private void handleInterpolationSettings(MoudPackets.InterpolationSettingsPacket packet) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && client.field_1724.method_5667().equals(packet.playerId())) {
            PlayerPartConfigManager.InterpolationSettings settings = new PlayerPartConfigManager.InterpolationSettings();
            Map data = packet.settings();
            if (data.containsKey("enabled")) {
                settings.enabled = (Boolean)data.get("enabled");
            }
            if (data.containsKey("duration")) {
                settings.duration = ((Number)data.get("duration")).longValue();
            }
            if (data.containsKey("easing")) {
                String easingStr = (String)data.get("easing");
                try {
                    settings.easing = PlayerPartConfigManager.EasingType.valueOf(easingStr.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Unknown easing type: {}", (Object)easingStr);
                }
            }
            if (data.containsKey("speed")) {
                settings.speed = ((Number)data.get("speed")).floatValue();
            }
            PlayerPartConfigManager.getInstance().setPlayerInterpolationSettings(packet.playerId(), settings);
        }
    }

    private void handleManageWindow(MoudPackets.S2C_ManageWindowPacket packet) {
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            long handle = client.method_22683().method_4490();
            switch (packet.action()) {
                case SET_SIZE: {
                    GLFW.glfwSetWindowSize((long)handle, (int)packet.int1(), (int)packet.int2());
                    break;
                }
                case SET_POSITION: {
                    GLFW.glfwSetWindowPos((long)handle, (int)packet.int1(), (int)packet.int2());
                    break;
                }
                case SET_TITLE: {
                    GLFW.glfwSetWindowTitle((long)handle, (CharSequence)packet.string1());
                    break;
                }
                case SET_BORDERLESS: {
                    GLFW.glfwSetWindowAttrib((long)handle, (int)131077, (int)(packet.bool1() ? 0 : 1));
                    break;
                }
                case MAXIMIZE: {
                    GLFW.glfwMaximizeWindow((long)handle);
                    break;
                }
                case MINIMIZE: {
                    GLFW.glfwIconifyWindow((long)handle);
                    break;
                }
                case RESTORE: {
                    GLFW.glfwRestoreWindow((long)handle);
                }
            }
        });
    }

    private void handleTransitionWindow(MoudPackets.S2C_TransitionWindowPacket packet) {
        class_310.method_1551().execute(() -> WindowAnimator.startAnimation(packet.targetX(), packet.targetY(), packet.targetWidth(), packet.targetHeight(), packet.duration(), packet.easing()));
    }

    private void handleFirstPersonConfig(MoudPackets.FirstPersonConfigPacket packet) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && client.field_1724.method_5667().equals(packet.playerId())) {
            ExternalPartConfigLayer.updateFirstPersonConfig(packet.playerId(), packet.config());
        }
    }

    private void handleExtendedPlayerState(MoudPackets.ExtendedPlayerStatePacket packet) {
        if (this.playerStateManager != null) {
            this.playerStateManager.updateExtendedPlayerState(packet.hideHotbar(), packet.hideHand(), packet.hideExperience(), packet.hideHealth(), packet.hideFood(), packet.hideCrosshair(), packet.hideChat(), packet.hidePlayerList(), packet.hideScoreboard());
        }
    }

    private void initializeMoudServices() {
        if (this.moudServicesInitialized) {
            return;
        }
        LOGGER.info("Initializing Moud services for new connection...");
        this.apiService = new ClientAPIService();
        this.scriptingRuntime = new ClientScriptingRuntime(this.apiService);
        this.apiService.setRuntime(this.scriptingRuntime);
        this.sharedValueManager = SharedValueManager.getInstance();
        this.sharedValueManager.initialize();
        this.clientCameraManager = new ClientCameraManager();
        this.playerStateManager = PlayerStateManager.getInstance();
        this.clientCursorManager = ClientCursorManager.getInstance();
        LOGGER.info("ClientCursorManager initialized: {}", (Object)(this.clientCursorManager != null ? 1 : 0));
        this.moudServicesInitialized = true;
    }

    private void cleanupMoudServices() {
        LOGGER.info("Cleaning up Moud services...");
        if (this.scriptingRuntime != null) {
            this.scriptingRuntime.shutdown();
            this.scriptingRuntime = null;
        }
        if (this.apiService != null) {
            this.apiService.cleanup();
            this.apiService = null;
        }
        if (this.sharedValueManager != null) {
            this.sharedValueManager.cleanup();
        }
        if (this.playerStateManager != null) {
            this.playerStateManager.reset();
        }
        if (this.clientCursorManager != null) {
            this.clientCursorManager.clear();
        }
        this.clientCameraManager = null;
        this.playerStateManager = null;
        this.moudServicesInitialized = false;
    }

    private void handleCameraControl(MoudPackets.CameraControlPacket packet) {
        if (this.apiService == null || this.apiService.camera == null) {
            return;
        }
        switch (packet.action()) {
            case ENABLE: {
                this.apiService.camera.enableCustomCamera();
                break;
            }
            case DISABLE: {
                this.apiService.camera.disableCustomCamera();
                break;
            }
            case TRANSITION_TO: {
                if (packet.options() == null) break;
                this.apiService.camera.transitionTo(Value.asValue((Object)packet.options()));
                break;
            }
            case SNAP_TO: {
                if (packet.options() == null) break;
                this.apiService.camera.snapTo(Value.asValue((Object)packet.options()));
            }
        }
    }

    private void registerEventHandlers() {
        ClientPlayConnectionEvents.JOIN.register(this::onJoinServer);
        ClientPlayConnectionEvents.DISCONNECT.register(this::onDisconnectServer);
    }

    private void registerTickHandler() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (this.joinTime != -1L && this.waitingForResources.get() && System.currentTimeMillis() - this.joinTime > 10000L) {
                LOGGER.warn("Timed out waiting for Moud server handshake. Assuming non-Moud server and proceeding with join.");
                this.waitingForResources.set(false);
                this.resourcesLoaded.set(true);
                this.joinTime = -1L;
                this.cleanupMoudServices();
            }
            ClientLightingService.getInstance().tick();
            if (this.scriptingRuntime != null && this.scriptingRuntime.isInitialized()) {
                this.scriptingRuntime.processGeneralTaskQueue();
            }
            if (this.apiService != null && this.apiService.events != null) {
                this.apiService.events.dispatch("core:tick", Float.valueOf(client.method_60646().method_60637(true)));
            }
            if (this.apiService != null) {
                this.apiService.getUpdateManager().tick();
            }
            if (this.clientCameraManager != null) {
                this.clientCameraManager.tick();
            }
            ClientPlayerModelManager.getInstance().getModels().forEach(AnimatedPlayerModel::tick);
            ClientMovementTracker.getInstance().tick();
        });
    }

    private void registerRenderHandler() {
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            if (this.playerModelRenderer != null && !ClientPlayerModelManager.getInstance().getModels().isEmpty()) {
                class_4184 camera = context.camera();
                class_638 world = class_310.method_1551().field_1687;
                float tickDelta = context.tickCounter().method_60637(true);
                for (AnimatedPlayerModel model : ClientPlayerModelManager.getInstance().getModels()) {
                    double x = model.getInterpolatedX(tickDelta) - camera.method_19326().method_10216();
                    double y = model.getInterpolatedY(tickDelta) - camera.method_19326().method_10214();
                    double z = model.getInterpolatedZ(tickDelta) - camera.method_19326().method_10215();
                    class_4587 matrices = new class_4587();
                    matrices.method_22904(x, y, z);
                    int light = class_761.method_23794((class_1920)world, (class_2338)model.getBlockPos());
                    this.playerModelRenderer.render(model, matrices, context.consumers(), light, tickDelta);
                }
            }
            if (this.clientCursorManager != null) {
                this.clientCursorManager.render(context.matrixStack(), context.consumers(), context.tickCounter().method_60637(true));
            }
        });
    }

    private void registerShutdownHandler() {
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> this.cleanupMoudServices());
    }

    private void onJoinServer(class_634 handler, PacketSender sender, class_310 client) {
        this.initializeMoudServices();
        this.resourcesLoaded.set(false);
        this.waitingForResources.set(true);
        this.joinTime = System.currentTimeMillis();
        ClientPacketWrapper.sendToServer(new MoudPackets.HelloPacket(1));
    }

    private void onDisconnectServer(class_634 handler, class_310 client) {
        isOnMoudServer = false;
        if (this.apiService != null && this.apiService.events != null) {
            this.apiService.events.dispatch("core:disconnect", "Player disconnected");
        }
        this.joinTime = -1L;
        if (client.field_1724 != null) {
            PlayerPartConfigManager.getInstance().clearConfig(client.field_1724.method_5667());
        }
        LOGGER.info("Disconnecting from server, cleaning up...");
        ClientPlayerModelManager.getInstance().clear();
        this.dynamicPack.set(null);
        this.currentResourcesHash = "";
        this.cleanupMoudServices();
        MoudClientMod.setCustomCameraActive(false);
    }

    private void registerAnimationLayer() {
        PlayerAnimationAccess.REGISTER_ANIMATION_EVENT.register((player, manager) -> manager.addAnimLayer(10000, (IAnimation)new ExternalPartConfigLayer(player.method_5667())));
    }

    private void handleSyncScripts(MoudPackets.SyncClientScriptsPacket packet) {
        isOnMoudServer = true;
        this.joinTime = -1L;
        if (this.apiService != null && this.apiService.events != null) {
            this.apiService.events.dispatch("core:scriptsReceived", packet.hash());
        }
        if (this.currentResourcesHash.equals(packet.hash())) {
            this.loadScriptsOnly(packet.scriptData());
            this.resourcesLoaded.set(true);
            this.waitingForResources.set(false);
            return;
        }
        this.waitingForResources.set(true);
        this.currentResourcesHash = packet.hash();
        HashMap<String, byte[]> scriptsData = new HashMap<String, byte[]>();
        HashMap<String, byte[]> assetsData = new HashMap<String, byte[]>();
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(packet.scriptData()));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                byte[] data = zis.readAllBytes();
                if (name.startsWith("scripts/")) {
                    scriptsData.put(name.substring("scripts/".length()), data);
                    continue;
                }
                if (!name.startsWith("assets/")) continue;
                assetsData.put(name, data);
                if (!name.contains("animation") || !name.endsWith(".json")) continue;
                String animationName = name.substring(name.lastIndexOf(47) + 1, name.lastIndexOf(46));
                LOGGER.info("Loading animation: {} from path: {}", (Object)animationName, (Object)name);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error unpacking script & asset archive", (Throwable)e);
            this.waitingForResources.set(false);
            return;
        }
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            InMemoryPackResources newPack = new InMemoryPackResources(MOUDPACK_ID.toString(), class_2561.method_30163((String)"Moud Dynamic Server Resources"), assetsData);
            this.dynamicPack.set(newPack);
            class_3283 manager = client.method_1520();
            manager.method_14445();
            ArrayList<String> enabledPacks = new ArrayList<String>(manager.method_29210());
            if (!enabledPacks.contains(MOUDPACK_ID.toString())) {
                enabledPacks.add(MOUDPACK_ID.toString());
            }
            manager.method_14447(enabledPacks);
            this.loadScriptsOnly(scriptsData);
            this.resourcesLoaded.set(true);
            this.waitingForResources.set(false);
            if (this.apiService != null && this.apiService.events != null) {
                this.apiService.events.dispatch("core:resourcesReloaded", new Object[0]);
            }
            LOGGER.info("Dynamic resources enabled and scripts loaded.");
        });
    }

    public boolean shouldBlockJoin() {
        return this.waitingForResources.get() && !this.resourcesLoaded.get();
    }

    private void handlePlayPlayerAnimation(MoudPackets.S2C_PlayPlayerAnimationPacket packet) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            IAnimatedPlayer animatedPlayer = (IAnimatedPlayer)client.field_1724;
            animatedPlayer.getAnimationPlayer().playAnimation(packet.animationId());
        }
    }

    private void handlePlayModelAnimation(MoudPackets.S2C_PlayModelAnimationPacket packet) {
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            AnimatedPlayerModel model = ClientPlayerModelManager.getInstance().getModel(packet.modelId());
            if (model != null) {
                model.playAnimation(packet.animationId());
                LOGGER.info("Playing animation '{}' on model {}.", (Object)packet.animationId(), (Object)packet.modelId());
            } else {
                LOGGER.warn("Received animation for unknown model ID: {}", (Object)packet.modelId());
            }
        });
    }

    private void handlePlayerModelCreate(MoudPackets.PlayerModelCreatePacket packet) {
        class_310.method_1551().execute(() -> {
            AnimatedPlayerModel model = ClientPlayerModelManager.getInstance().createModel(packet.modelId());
            if (model == null) {
                LOGGER.warn("Failed to create player model {} because the client world is unavailable", (Object)packet.modelId());
                return;
            }
            model.updatePositionAndRotation(packet.position(), 0.0f, 0.0f);
            if (packet.skinUrl() != null && !packet.skinUrl().isEmpty()) {
                model.updateSkin(packet.skinUrl());
            }
            LOGGER.info("Created player model with ID: {} at position: {}", (Object)packet.modelId(), (Object)packet.position());
        });
    }

    private void handlePlayerModelRemove(MoudPackets.PlayerModelRemovePacket packet) {
        class_310.method_1551().execute(() -> {
            ClientPlayerModelManager.getInstance().removeModel(packet.modelId());
            LOGGER.info("Removed player model with ID: {}", (Object)packet.modelId());
        });
    }

    private void loadScriptsOnly(byte[] zippedScriptData) {
        HashMap<String, byte[]> scriptsData = new HashMap<String, byte[]>();
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zippedScriptData));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory() || !entry.getName().startsWith("scripts/")) continue;
                scriptsData.put(entry.getName().substring("scripts/".length()), zis.readAllBytes());
            }
        }
        catch (IOException e) {
            LOGGER.error("Error unpacking scripts from archive for script-only load", (Throwable)e);
        }
        this.loadScriptsOnly(scriptsData);
    }

    private void loadScriptsOnly(Map<String, byte[]> scriptsData) {
        if (this.scriptingRuntime == null || this.apiService == null) {
            LOGGER.error("Scripting runtime or API service is null. Aborting script load.");
            return;
        }
        ((CompletableFuture)((CompletableFuture)this.scriptingRuntime.initialize().thenCompose(v -> {
            this.apiService.updateScriptingContext(this.scriptingRuntime.getContext());
            if (!scriptsData.isEmpty()) {
                return this.scriptingRuntime.loadScripts(scriptsData);
            }
            return CompletableFuture.completedFuture(null);
        })).thenRun(() -> LOGGER.info("Client scripts loaded successfully"))).exceptionally(t -> {
            LOGGER.error("A failure occurred during runtime initialization or script loading", t);
            return null;
        });
    }

    private void handleScriptEvent(MoudPackets.ClientboundScriptEventPacket packet) {
        if (this.scriptingRuntime != null && this.scriptingRuntime.isInitialized()) {
            this.scriptingRuntime.triggerNetworkEvent(packet.eventName(), packet.eventData());
        }
    }

    private void handleCameraLock(MoudPackets.CameraLockPacket packet) {
        if (this.apiService != null && this.apiService.camera != null) {
            if (packet.isLocked()) {
                this.apiService.camera.enableCustomCamera();
            } else {
                this.apiService.camera.disableCustomCamera();
            }
        }
    }

    private void handleAdvancedCameraLock(MoudPackets.AdvancedCameraLockPacket packet) {
        if (this.apiService != null && this.apiService.camera != null) {
            if (packet.isLocked()) {
                this.apiService.camera.enableCustomCamera();
                Value options = Value.asValue((Object)ProxyObject.fromMap(Map.of("position", packet.position(), "yaw", Float.valueOf(packet.rotation().x), "pitch", Float.valueOf(packet.rotation().y), "roll", Float.valueOf(packet.rotation().z))));
                this.apiService.camera.snapTo(options);
            } else {
                this.apiService.camera.disableCustomCamera();
            }
        }
    }

    private void handleCameraUpdate(MoudPackets.CameraUpdatePacket packet) {
        if (this.apiService != null && this.apiService.camera != null && this.apiService.camera.isCustomCameraActive()) {
            Value options = Value.asValue((Object)ProxyObject.fromMap(Map.of("position", packet.position(), "yaw", Float.valueOf(packet.rotation().x), "pitch", Float.valueOf(packet.rotation().y), "roll", Float.valueOf(packet.rotation().z))));
            this.apiService.camera.snapTo(options);
        }
    }

    private void handlePlayerState(MoudPackets.PlayerStatePacket packet) {
        if (this.playerStateManager != null) {
            this.playerStateManager.updatePlayerState(packet.hideHotbar(), packet.hideHand(), packet.hideExperience());
        }
    }

    private void handleSharedValueSync(MoudPackets.SyncSharedValuesPacket packet) {
        if (this.sharedValueManager != null) {
            this.sharedValueManager.handleServerSync(packet);
        }
    }

    private void handlePlayerModelUpdate(MoudPackets.PlayerModelUpdatePacket packet) {
        class_310.method_1551().execute(() -> {
            AnimatedPlayerModel model = ClientPlayerModelManager.getInstance().getModel(packet.modelId());
            if (model != null) {
                model.updatePositionAndRotation(packet.position(), packet.yaw(), packet.pitch());
            } else {
                LOGGER.warn("Received update for unknown model ID: {}", (Object)packet.modelId());
            }
        });
    }

    private void handlePlayerModelSkin(MoudPackets.PlayerModelSkinPacket packet) {
        class_310.method_1551().execute(() -> {
            AnimatedPlayerModel model = ClientPlayerModelManager.getInstance().getModel(packet.modelId());
            if (model != null) {
                model.updateSkin(packet.skinUrl());
            } else {
                LOGGER.warn("Received skin update for unknown model ID: {}", (Object)packet.modelId());
            }
        });
    }

    private void handleCameraRelease(MoudPackets.CameraReleasePacket packet) {
        if (this.apiService != null && this.apiService.camera != null) {
            this.apiService.camera.disableCustomCamera();
        }
    }

    public void method_14453(Consumer<class_3288> profileAdder) {
        final InMemoryPackResources pack = this.dynamicPack.get();
        if (pack != null) {
            class_3288.class_7680 factory = new class_3288.class_7680(){

                @Nullable
                public class_3262 method_52424(class_9224 info) {
                    return pack;
                }

                @Nullable
                public class_3262 method_52425(class_9224 info, class_3288.class_7679 metadata) {
                    return pack;
                }
            };
            class_9224 info = new class_9224(MOUDPACK_ID.toString(), class_2561.method_30163((String)"Moud Dynamic Server Resources"), class_5352.field_25350, null);
            class_3288.class_7679 metadata = new class_3288.class_7679(class_2561.method_30163((String)"Moud Dynamic Server Resources"), class_3281.field_14224, class_7699.method_45397(), Collections.emptyList());
            class_9225 position = new class_9225(true, class_3288.class_3289.field_14280, false);
            class_3288 profile = new class_3288(info, factory, metadata, position);
            profileAdder.accept(profile);
        }
    }

    private void registerResourcePackProvider() {
        try {
            Field providerField = class_310.method_1551().method_1520().getClass().getDeclaredField("providers");
            providerField.setAccessible(true);
            Set providers = (Set)providerField.get(class_310.method_1551().method_1520());
            providers.add(this);
            LOGGER.info("Successfully registered dynamic resource pack provider.");
        }
        catch (Exception e) {
            LOGGER.error("Failed to register dynamic resource pack provider via reflection", (Throwable)e);
        }
    }

    public static boolean isOnMoudServer() {
        return isOnMoudServer;
    }

    static {
        customCameraActive = false;
        isOnMoudServer = false;
    }
}

