/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.animation;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.moud.api.math.Vector3;
import com.zigythebird.playeranim.accessors.IAnimatedPlayer;
import com.zigythebird.playeranim.animation.PlayerAnimManager;
import com.zigythebird.playeranim.animation.PlayerAnimResources;
import com.zigythebird.playeranim.animation.PlayerAnimationController;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.animation.layered.IAnimation;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractFadeModifier;
import com.zigythebird.playeranimcore.easing.EasingType;
import com.zigythebird.playeranimcore.enums.PlayState;
import java.util.Base64;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5602;
import net.minecraft.class_591;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_745;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimatedPlayerModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnimatedPlayerModel.class);
    private static final double MOVEMENT_THRESHOLD_SQUARED = 1.0E-6;
    private final class_745 fakePlayer;
    private final PlayerAnimationController animationController;
    private final class_591<class_745> model;
    private double x;
    private double y;
    private double z;
    private double prevX;
    private double prevY;
    private double prevZ;
    private float yaw;
    private float pitch;
    private float prevYaw;
    private float prevPitch;
    private boolean hasPosition;
    private MovementState currentState = MovementState.IDLE;
    private String overrideAnimation = null;
    private long overrideAnimationEndTime = 0L;

    public AnimatedPlayerModel(class_638 world) {
        class_310 client = class_310.method_1551();
        this.model = new class_591(client.method_31974().method_32072(class_5602.field_27577), false);
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), "MoudModel_" + this.hashCode());
        this.fakePlayer = new class_745(world, gameProfile);
        this.animationController = new PlayerAnimationController((class_742)this.fakePlayer, (controller, state, animSetter) -> PlayState.CONTINUE);
        PlayerAnimManager manager = ((IAnimatedPlayer)this.fakePlayer).playerAnimLib$getAnimManager();
        manager.addAnimLayer(1000, (IAnimation)this.animationController);
        LOGGER.debug("AnimatedPlayerModel created. Controller hash: {}", (Object)this.animationController.hashCode());
        this.playBaseAnimation(MovementState.IDLE);
    }

    public void tick() {
        boolean isMoving;
        this.fakePlayer.method_5773();
        double dx = this.x - this.prevX;
        double dz = this.z - this.prevZ;
        boolean bl = isMoving = dx * dx + dz * dz > 1.0E-6;
        if (isMoving && this.currentState == MovementState.IDLE) {
            this.setState(MovementState.WALKING);
        } else if (!isMoving && this.currentState == MovementState.WALKING) {
            this.setState(MovementState.IDLE);
        }
        if (this.overrideAnimation != null && System.currentTimeMillis() > this.overrideAnimationEndTime) {
            LOGGER.debug("Override animation '{}' ended. Returning to base state: {}", (Object)this.overrideAnimation, (Object)this.currentState);
            this.overrideAnimation = null;
            this.playBaseAnimation(this.currentState);
        }
    }

    private void setState(MovementState newState) {
        if (this.currentState == newState) {
            return;
        }
        LOGGER.debug("Model state change: {} -> {}", (Object)this.currentState, (Object)newState);
        this.currentState = newState;
        if (this.overrideAnimation == null) {
            this.playBaseAnimation(newState);
        }
    }

    private void playBaseAnimation(MovementState state) {
        String animId = state == MovementState.IDLE ? "moud:idle" : "moud:walk";
        Animation animation = PlayerAnimResources.getAnimation((class_2960)class_2960.method_60654((String)animId));
        if (animation != null) {
            this.animationController.triggerAnimation(RawAnimation.begin().then(animation, Animation.LoopType.LOOP));
            LOGGER.debug("Playing base animation '{}'. Controller active: {}", (Object)animId, (Object)this.animationController.isActive());
        } else {
            LOGGER.warn("Base animation '{}' not found in PlayerAnimResources. Make sure it is packaged correctly.", (Object)animId);
        }
    }

    public void playAnimationWithFade(String animationIdStr, int durationTicks) {
        Animation animation;
        class_2960 animationId = class_2960.method_12829((String)animationIdStr);
        if (animationId == null) {
            animationId = class_2960.method_60655((String)"moud", (String)animationIdStr);
        }
        if ((animation = PlayerAnimResources.getAnimation((class_2960)animationId)) != null) {
            this.overrideAnimation = animationIdStr;
            long duration = Math.max(50L, (long)(animation.length() * 50.0f));
            this.overrideAnimationEndTime = System.currentTimeMillis() + duration;
            RawAnimation newAnimation = RawAnimation.begin().thenPlay(animation);
            AbstractFadeModifier fade = AbstractFadeModifier.standardFadeIn((int)durationTicks, (EasingType)EasingType.EASE_IN_OUT_SINE);
            this.animationController.replaceAnimationWithFade(fade, newAnimation);
            LOGGER.debug("Triggering one-shot animation '{}' WITH FADE. Duration: {} ticks", (Object)animationId, (Object)durationTicks);
        } else {
            LOGGER.warn("Animation '{}' not found in PlayerAnimResources.", (Object)animationId);
        }
    }

    public void playAnimation(String animationIdStr) {
        Animation animation;
        class_2960 animationId = class_2960.method_12829((String)animationIdStr);
        if (animationId == null) {
            animationId = class_2960.method_60655((String)"moud", (String)animationIdStr);
        }
        if ((animation = PlayerAnimResources.getAnimation((class_2960)animationId)) != null) {
            boolean isBaseMovementAnim;
            boolean bl = isBaseMovementAnim = "idle".equals(animationId.method_12832()) || "walk".equals(animationId.method_12832());
            if (isBaseMovementAnim) {
                this.overrideAnimation = null;
                this.setState("walk".equals(animationId.method_12832()) ? MovementState.WALKING : MovementState.IDLE);
                LOGGER.debug("Triggering base animation '{}'.", (Object)animationId);
            } else {
                this.overrideAnimation = animationIdStr;
                long duration = Math.max(50L, (long)(animation.length() * 50.0f));
                this.overrideAnimationEndTime = System.currentTimeMillis() + duration;
                this.animationController.triggerAnimation(RawAnimation.begin().thenPlay(animation));
                LOGGER.debug("Triggering one-shot animation '{}'. Duration: {}ms", (Object)animationId, (Object)duration);
            }
        } else {
            LOGGER.warn("Animation '{}' not found in PlayerAnimResources.", (Object)animationId);
        }
    }

    public void setupAnim(float partialTick) {
        this.fakePlayer.method_23327(this.getInterpolatedX(partialTick), this.getInterpolatedY(partialTick), this.getInterpolatedZ(partialTick));
        this.fakePlayer.method_36456(this.getInterpolatedYaw(partialTick));
        this.fakePlayer.method_36457(this.getInterpolatedPitch(partialTick));
        this.fakePlayer.field_6241 = this.fakePlayer.method_36454();
        this.fakePlayer.field_6283 = this.fakePlayer.method_36454();
        this.model.method_17087((class_1309)this.fakePlayer, 0.0f, 0.0f, 0.0f, this.fakePlayer.method_36454(), this.fakePlayer.method_36455());
        LOGGER.trace("SetupAnim called for Model. Controller Active: {}", (Object)this.animationController.isActive());
    }

    public class_745 getFakePlayer() {
        return this.fakePlayer;
    }

    public class_591<class_745> getModel() {
        return this.model;
    }

    public void updateSkin(String skinUrl) {
        if (skinUrl == null || skinUrl.isEmpty()) {
            LOGGER.warn("Empty skin URL provided for player model");
            return;
        }
        try {
            GameProfile gameProfile = this.fakePlayer.method_7334();
            gameProfile.getProperties().clear();
            String textureData = String.format("{\"textures\":{\"SKIN\":{\"url\":\"%s\"}}}", skinUrl);
            String encoded = Base64.getEncoder().encodeToString(textureData.getBytes());
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", encoded));
            LOGGER.info("Applied skin URL to player model: {}", (Object)skinUrl);
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply skin to player model", (Throwable)e);
        }
    }

    public void updatePositionAndRotation(Vector3 position, float yaw, float pitch) {
        if (!this.hasPosition) {
            this.prevX = position.x;
            this.prevY = position.y;
            this.prevZ = position.z;
            this.prevYaw = yaw;
            this.prevPitch = pitch;
            this.hasPosition = true;
        } else {
            this.prevX = this.x;
            this.prevY = this.y;
            this.prevZ = this.z;
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
        }
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public double getInterpolatedX(float tickDelta) {
        return class_3532.method_16436((double)tickDelta, (double)this.prevX, (double)this.x);
    }

    public double getInterpolatedY(float tickDelta) {
        return class_3532.method_16436((double)tickDelta, (double)this.prevY, (double)this.y);
    }

    public double getInterpolatedZ(float tickDelta) {
        return class_3532.method_16436((double)tickDelta, (double)this.prevZ, (double)this.z);
    }

    public float getInterpolatedYaw(float tickDelta) {
        return class_3532.method_17821((float)tickDelta, (float)this.prevYaw, (float)this.yaw);
    }

    public float getInterpolatedPitch(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.prevPitch, (float)this.pitch);
    }

    public class_2338 getBlockPos() {
        return class_2338.method_49637((double)this.x, (double)this.y, (double)this.z);
    }

    private static enum MovementState {
        IDLE,
        WALKING;

    }
}

