/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.animation;

import com.zigythebird.playeranim.PlayerAnimLibMod;
import com.zigythebird.playeranim.animation.PlayerAnimResources;
import com.zigythebird.playeranim.api.PlayerAnimationAccess;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import net.minecraft.class_2960;
import net.minecraft.class_742;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAnimationPlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientAnimationPlayer.class);
    private final class_742 player;
    private AnimationController animationController;

    public ClientAnimationPlayer(class_742 player) {
        this.player = player;
    }

    private AnimationController getController() {
        if (this.animationController == null) {
            try {
                this.animationController = (AnimationController)PlayerAnimationAccess.getPlayerAnimationLayer((class_742)this.player, (class_2960)PlayerAnimLibMod.ANIMATION_LAYER_ID);
                LOGGER.debug("ClientAnimationPlayer controller retrieved. Hash: {}", (Object)this.animationController.hashCode());
            }
            catch (Exception e) {
                LOGGER.error("Failed to retrieve PlayerAnimationController for local player.", (Throwable)e);
            }
        }
        return this.animationController;
    }

    public void playAnimation(String animationIdStr) {
        Animation animation;
        AnimationController controller = this.getController();
        if (controller == null) {
            LOGGER.error("Could not get animation controller for player '{}'.", (Object)this.player.method_5477().getString());
            return;
        }
        class_2960 animationId = class_2960.method_12829((String)animationIdStr);
        if (animationId == null) {
            animationId = class_2960.method_60655((String)"moud", (String)animationIdStr);
        }
        if ((animation = PlayerAnimResources.getAnimation((class_2960)animationId)) == null) {
            LOGGER.warn("Animation '{}' not found in PlayerAnimResources.", (Object)animationId);
            return;
        }
        controller.triggerAnimation(RawAnimation.begin().thenPlay(animation));
        LOGGER.info("Triggering animation '{}' on local player.", (Object)animationId);
    }
}

