/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.animation;

import com.moud.client.animation.AnimatedPlayerModel;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPlayerModelManager {
    private static final ClientPlayerModelManager INSTANCE = new ClientPlayerModelManager();
    private final Map<Long, AnimatedPlayerModel> models = new ConcurrentHashMap<Long, AnimatedPlayerModel>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientPlayerModelManager.class);

    private ClientPlayerModelManager() {
    }

    public static ClientPlayerModelManager getInstance() {
        return INSTANCE;
    }

    public AnimatedPlayerModel createModel(long modelId) {
        class_310 client = class_310.method_1551();
        if (!client.method_18854()) {
            return (AnimatedPlayerModel)client.method_5385(() -> this.createModel(modelId)).join();
        }
        class_638 world = client.field_1687;
        if (world == null) {
            LOGGER.warn("Tried to create player model {} without an active client world", (Object)modelId);
            return null;
        }
        return this.models.computeIfAbsent(modelId, id -> new AnimatedPlayerModel(world));
    }

    public void removeModel(long modelId) {
        this.models.remove(modelId);
    }

    public AnimatedPlayerModel getModel(long modelId) {
        return this.models.get(modelId);
    }

    public Collection<AnimatedPlayerModel> getModels() {
        return this.models.values();
    }

    public void clear() {
        this.models.clear();
    }
}

