/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.animation;

import com.moud.api.math.Vector3;
import com.moud.client.animation.PlayerPartConfigManager;
import com.zigythebird.playeranimcore.animation.layered.IAnimation;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonConfiguration;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonMode;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class ExternalPartConfigLayer
implements IAnimation {
    private final UUID playerUuid;
    private static final Map<UUID, FirstPersonConfiguration> playerFirstPersonConfigs = new ConcurrentHashMap<UUID, FirstPersonConfiguration>();
    private static final FirstPersonConfiguration DEFAULT_FIRST_PERSON_CONFIG = new FirstPersonConfiguration().setShowRightArm(true).setShowLeftArm(true).setShowRightItem(true).setShowLeftItem(true).setShowArmor(true);

    public ExternalPartConfigLayer(UUID playerUuid) {
        this.playerUuid = playerUuid;
    }

    public static void updateFirstPersonConfig(UUID playerId, Map<String, Object> config) {
        FirstPersonConfiguration configToUpdate = playerFirstPersonConfigs.computeIfAbsent(playerId, k -> new FirstPersonConfiguration());
        if (config.containsKey("showRightArm")) {
            configToUpdate.setShowRightArm(((Boolean)config.get("showRightArm")).booleanValue());
        }
        if (config.containsKey("showLeftArm")) {
            configToUpdate.setShowLeftArm(((Boolean)config.get("showLeftArm")).booleanValue());
        }
        if (config.containsKey("showRightItem")) {
            configToUpdate.setShowRightItem(((Boolean)config.get("showRightItem")).booleanValue());
        }
        if (config.containsKey("showLeftItem")) {
            configToUpdate.setShowLeftItem(((Boolean)config.get("showLeftItem")).booleanValue());
        }
        if (config.containsKey("showArmor")) {
            configToUpdate.setShowArmor(((Boolean)config.get("showArmor")).booleanValue());
        }
    }

    public static void clearFirstPersonConfig(UUID playerId) {
        playerFirstPersonConfigs.remove(playerId);
    }

    public boolean isActive() {
        String[] parts;
        PlayerPartConfigManager.PartConfig anyConfig = null;
        for (String part : parts = new String[]{"head", "body", "right_arm", "left_arm", "right_leg", "left_leg"}) {
            PlayerPartConfigManager.PartConfig config = PlayerPartConfigManager.getInstance().getPartConfig(this.playerUuid, part);
            if (config == null) continue;
            anyConfig = config;
            break;
        }
        return anyConfig != null;
    }

    @NotNull
    public FirstPersonMode getFirstPersonMode() {
        return FirstPersonMode.THIRD_PERSON_MODEL;
    }

    @NotNull
    public FirstPersonConfiguration getFirstPersonConfiguration() {
        return playerFirstPersonConfigs.getOrDefault(this.playerUuid, DEFAULT_FIRST_PERSON_CONFIG);
    }

    public PlayerAnimBone get3DTransform(@NotNull PlayerAnimBone bone) {
        PlayerPartConfigManager.PartConfig config = PlayerPartConfigManager.getInstance().getPartConfig(this.playerUuid, bone.getName());
        if (config == null) {
            return bone;
        }
        if (config.visible != null && !config.visible.booleanValue()) {
            bone.setScaleX(0.0f);
            bone.setScaleY(0.0f);
            bone.setScaleZ(0.0f);
            return bone;
        }
        if (config.overrideAnimation) {
            bone.setToInitialPose();
        }
        Vector3 position = config.getInterpolatedPosition();
        Vector3 rotation = config.getInterpolatedRotation();
        Vector3 scale = config.getInterpolatedScale();
        if (position != null) {
            bone.setPosX(bone.getPosX() + position.x);
            bone.setPosY(bone.getPosY() + position.y);
            bone.setPosZ(bone.getPosZ() + position.z);
        }
        if (rotation != null) {
            bone.setRotX(bone.getRotX() + (float)Math.PI / 180 * rotation.x);
            bone.setRotY(bone.getRotY() + (float)Math.PI / 180 * rotation.y);
            bone.setRotZ(bone.getRotZ() + (float)Math.PI / 180 * rotation.z);
        }
        if (scale != null) {
            bone.setScaleX(bone.getScaleX() * scale.x);
            bone.setScaleY(bone.getScaleY() * scale.y);
            bone.setScaleZ(bone.getScaleZ() * scale.z);
        }
        return bone;
    }
}

