/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.animation;

import com.moud.api.math.Vector3;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PlayerPartConfigManager {
    private static final PlayerPartConfigManager INSTANCE = new PlayerPartConfigManager();
    private final Map<UUID, Map<String, PartConfig>> playerConfigs = new ConcurrentHashMap<UUID, Map<String, PartConfig>>();
    private final Map<UUID, PlayerInterpolationSettings> playerSettings = new ConcurrentHashMap<UUID, PlayerInterpolationSettings>();
    private static InterpolationSettings globalSettings = new InterpolationSettings();

    private PlayerPartConfigManager() {
    }

    public static PlayerPartConfigManager getInstance() {
        return INSTANCE;
    }

    public void updatePartConfig(UUID playerId, String partName, Map<String, Object> properties) {
        PartConfig config = this.playerConfigs.computeIfAbsent(playerId, k -> new ConcurrentHashMap()).computeIfAbsent(partName, k -> new PartConfig());
        Vector3 oldRotation = config.rotation;
        Vector3 oldPosition = config.position;
        Vector3 oldScale = config.scale;
        config.update(properties);
        InterpolationSettings settings = this.getEffectiveSettings(playerId);
        if (settings.enabled) {
            config.setupInterpolation(oldRotation, oldPosition, oldScale, settings);
        }
    }

    public PartConfig getPartConfig(UUID playerId, String partName) {
        Map<String, PartConfig> parts = this.playerConfigs.get(playerId);
        return parts != null ? parts.get(partName) : null;
    }

    public void setPlayerInterpolationSettings(UUID playerId, InterpolationSettings settings) {
        this.playerSettings.computeIfAbsent(playerId, k -> new PlayerInterpolationSettings()).update(settings);
    }

    public static void setGlobalInterpolationSettings(InterpolationSettings settings) {
        globalSettings = settings;
    }

    private InterpolationSettings getEffectiveSettings(UUID playerId) {
        PlayerInterpolationSettings playerSetting = this.playerSettings.get(playerId);
        if (playerSetting != null && playerSetting.hasOverrides()) {
            return playerSetting.getEffectiveSettings(globalSettings);
        }
        return globalSettings;
    }

    public void clearConfig(UUID playerId) {
        this.playerConfigs.remove(playerId);
        this.playerSettings.remove(playerId);
    }

    public static class PartConfig {
        public Vector3 position;
        public Vector3 rotation;
        public Vector3 scale;
        public Boolean visible;
        public boolean overrideAnimation = false;
        private Vector3 fromRotation;
        private Vector3 fromPosition;
        private Vector3 fromScale;
        private Vector3 targetRotation;
        private Vector3 targetPosition;
        private Vector3 targetScale;
        private long interpolationStart;
        private InterpolationSettings interpolationSettings;
        private boolean isInterpolating = false;

        public void update(Map<String, Object> props) {
            Object overrideProp;
            Object visibleProp;
            if (props.containsKey("position")) {
                this.position = this.parseVector(props.get("position"));
            }
            if (props.containsKey("rotation")) {
                this.rotation = this.parseVector(props.get("rotation"));
            }
            if (props.containsKey("scale")) {
                this.scale = this.parseVector(props.get("scale"));
            }
            if (props.containsKey("visible") && (visibleProp = props.get("visible")) instanceof Boolean) {
                this.visible = (Boolean)visibleProp;
            }
            if (props.containsKey("overrideAnimation") && (overrideProp = props.get("overrideAnimation")) instanceof Boolean) {
                this.overrideAnimation = (Boolean)overrideProp;
            }
        }

        public void setupInterpolation(Vector3 oldRotation, Vector3 oldPosition, Vector3 oldScale, InterpolationSettings settings) {
            this.interpolationSettings = settings;
            this.fromRotation = oldRotation != null ? oldRotation : Vector3.zero();
            this.fromPosition = oldPosition != null ? oldPosition : Vector3.zero();
            this.fromScale = oldScale != null ? oldScale : new Vector3(1.0f, 1.0f, 1.0f);
            this.targetRotation = this.rotation != null ? this.rotation : Vector3.zero();
            this.targetPosition = this.position != null ? this.position : Vector3.zero();
            this.targetScale = this.scale != null ? this.scale : new Vector3(1.0f, 1.0f, 1.0f);
            this.interpolationStart = System.currentTimeMillis();
            this.isInterpolating = true;
        }

        public Vector3 getInterpolatedRotation() {
            if (!this.isInterpolating || this.interpolationSettings == null) {
                return this.rotation;
            }
            return this.interpolateVector(this.fromRotation, this.targetRotation);
        }

        public Vector3 getInterpolatedPosition() {
            if (!this.isInterpolating || this.interpolationSettings == null) {
                return this.position;
            }
            return this.interpolateVector(this.fromPosition, this.targetPosition);
        }

        public Vector3 getInterpolatedScale() {
            if (!this.isInterpolating || this.interpolationSettings == null) {
                return this.scale;
            }
            return this.interpolateVector(this.fromScale, this.targetScale);
        }

        private Vector3 interpolateVector(Vector3 from, Vector3 to) {
            long elapsed = System.currentTimeMillis() - this.interpolationStart;
            float progress = Math.min(1.0f, (float)elapsed / (float)this.interpolationSettings.duration);
            if (progress >= 1.0f) {
                this.isInterpolating = false;
                return to;
            }
            float easedProgress = this.applyEasing(progress, this.interpolationSettings.easing);
            return Vector3.lerp((Vector3)from, (Vector3)to, (float)easedProgress);
        }

        private float applyEasing(float t, EasingType easing) {
            return switch (easing.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> t;
                case 1 -> t * t;
                case 2 -> 1.0f - (1.0f - t) * (1.0f - t);
                case 3 -> {
                    if (t < 0.5f) {
                        yield 2.0f * t * t;
                    }
                    yield 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 2.0) / 2.0f;
                }
                case 4 -> t < 0.36363637f ? 7.5625f * t * t : (t < 0.72727275f ? 7.5625f * (t -= 0.54545456f) * t + 0.75f : ((double)t < 0.9090909090909091 ? 7.5625f * (t -= 0.8181818f) * t + 0.9375f : 7.5625f * (t -= 0.95454544f) * t + 0.984375f));
            };
        }

        private Vector3 parseVector(Object obj) {
            if (obj instanceof Vector3) {
                return (Vector3)obj;
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                Number xVal = (Number)map.get("x");
                Number yVal = (Number)map.get("y");
                Number zVal = (Number)map.get("z");
                double x = xVal != null ? xVal.doubleValue() : 0.0;
                double y = yVal != null ? yVal.doubleValue() : 0.0;
                double z = zVal != null ? zVal.doubleValue() : 0.0;
                return new Vector3(x, y, z);
            }
            return null;
        }
    }

    public static class InterpolationSettings {
        public boolean enabled = true;
        public long duration = 150L;
        public EasingType easing = EasingType.EASE_OUT;
        public float speed = 1.0f;

        public InterpolationSettings() {
        }

        public InterpolationSettings(boolean enabled, long duration, EasingType easing, float speed) {
            this.enabled = enabled;
            this.duration = duration;
            this.easing = easing;
            this.speed = speed;
        }
    }

    public static class PlayerInterpolationSettings {
        private Boolean enabledOverride;
        private Long durationOverride;
        private EasingType easingOverride;
        private Float speedOverride;

        public void update(InterpolationSettings settings) {
            this.enabledOverride = settings.enabled;
            this.durationOverride = settings.duration;
            this.easingOverride = settings.easing;
            this.speedOverride = Float.valueOf(settings.speed);
        }

        public boolean hasOverrides() {
            return this.enabledOverride != null || this.durationOverride != null || this.easingOverride != null || this.speedOverride != null;
        }

        public InterpolationSettings getEffectiveSettings(InterpolationSettings global) {
            return new InterpolationSettings(this.enabledOverride != null ? this.enabledOverride : global.enabled, this.durationOverride != null ? this.durationOverride : global.duration, this.easingOverride != null ? this.easingOverride : global.easing, this.speedOverride != null ? this.speedOverride.floatValue() : global.speed);
        }
    }

    public static enum EasingType {
        LINEAR,
        EASE_IN,
        EASE_OUT,
        EASE_IN_OUT,
        BOUNCE;

    }
}

