/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.api.service;

import com.moud.api.math.Vector3;
import com.moud.client.MoudClientMod;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5498;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CameraService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CameraService.class);
    private final class_310 client;
    private Context jsContext;
    private final CameraState currentState = new CameraState();
    private final CameraState targetState = new CameraState();
    private final CameraState startState = new CameraState();
    private long transitionStartTime = 0L;
    private long transitionDuration = 0L;
    private Value easingFunction = null;
    private boolean wasInFirstPerson = false;
    private boolean isAnimating = false;

    public CameraService() {
        this.client = class_310.method_1551();
    }

    public void setContext(Context jsContext) {
        this.jsContext = jsContext;
    }

    public void updateCamera(float tickDelta) {
        double easedProgress;
        if (!this.isCustomCameraActive() || !this.isAnimating) {
            return;
        }
        long elapsedTime = System.currentTimeMillis() - this.transitionStartTime;
        double progress = Math.min((double)elapsedTime / (double)this.transitionDuration, 1.0);
        if (this.easingFunction != null && this.easingFunction.canExecute()) {
            try {
                easedProgress = this.easingFunction.execute(new Object[]{progress}).asDouble();
            }
            catch (Exception e) {
                LOGGER.warn("Error executing JS easing function", (Throwable)e);
                easedProgress = 1.0 - Math.pow(1.0 - progress, 4.0);
            }
        } else {
            easedProgress = 1.0 - Math.pow(1.0 - progress, 4.0);
        }
        this.currentState.position.set(class_3532.method_16436((double)easedProgress, (double)this.startState.position.x, (double)this.targetState.position.x), class_3532.method_16436((double)easedProgress, (double)this.startState.position.y, (double)this.targetState.position.y), class_3532.method_16436((double)easedProgress, (double)this.startState.position.z, (double)this.targetState.position.z));
        this.currentState.yaw = class_3532.method_16436((double)easedProgress, (double)this.startState.yaw, (double)this.targetState.yaw);
        this.currentState.pitch = class_3532.method_16436((double)easedProgress, (double)this.startState.pitch, (double)this.targetState.pitch);
        this.currentState.roll = class_3532.method_16436((double)easedProgress, (double)this.startState.roll, (double)this.targetState.roll);
        this.currentState.fov = class_3532.method_16436((double)easedProgress, (double)this.startState.fov, (double)this.targetState.fov);
        if (progress >= 1.0) {
            this.isAnimating = false;
            this.easingFunction = null;
        }
    }

    @HostAccess.Export
    public void enableCustomCamera() {
        class_1297 camEntity;
        if (this.isCustomCameraActive()) {
            return;
        }
        boolean bl = this.wasInFirstPerson = !this.isThirdPerson();
        if (this.wasInFirstPerson) {
            this.setThirdPerson(true);
        }
        if ((camEntity = this.client.method_1560()) != null) {
            this.currentState.position.set(camEntity.method_23317(), camEntity.method_23320(), camEntity.method_23321());
            this.currentState.yaw = camEntity.method_36454();
            this.currentState.pitch = camEntity.method_36455();
            this.currentState.roll = 0.0;
            this.currentState.fov = ((Integer)this.client.field_1690.method_41808().method_41753()).intValue();
            this.targetState.position.set((Vector3dc)this.currentState.position);
            this.targetState.yaw = this.currentState.yaw;
            this.targetState.pitch = this.currentState.pitch;
            this.targetState.roll = this.currentState.roll;
            this.targetState.fov = this.currentState.fov;
        }
        MoudClientMod.setCustomCameraActive(true);
    }

    @HostAccess.Export
    public void disableCustomCamera() {
        if (!this.isCustomCameraActive()) {
            return;
        }
        if (this.wasInFirstPerson) {
            this.setThirdPerson(false);
        }
        this.wasInFirstPerson = false;
        MoudClientMod.setCustomCameraActive(false);
        this.isAnimating = false;
    }

    @HostAccess.Export
    public void transitionTo(Value options) {
        if (!this.isCustomCameraActive() || !options.hasMembers()) {
            return;
        }
        this.isAnimating = false;
        this.startState.position.set((Vector3dc)this.currentState.position);
        this.startState.yaw = this.currentState.yaw;
        this.startState.pitch = this.currentState.pitch;
        this.startState.roll = this.currentState.roll;
        this.startState.fov = this.currentState.fov;
        if (options.hasMember("position")) {
            Value pos = options.getMember("position");
            this.targetState.position.set(pos.getMember("x").asDouble(), pos.getMember("y").asDouble(), pos.getMember("z").asDouble());
        }
        if (options.hasMember("yaw")) {
            this.targetState.yaw = options.getMember("yaw").asDouble();
        }
        if (options.hasMember("pitch")) {
            this.targetState.pitch = options.getMember("pitch").asDouble();
        }
        if (options.hasMember("roll")) {
            this.targetState.roll = options.getMember("roll").asDouble();
        }
        if (options.hasMember("fov")) {
            this.targetState.fov = options.getMember("fov").asDouble();
        }
        this.transitionDuration = options.hasMember("duration") ? options.getMember("duration").asLong() : 1000L;
        this.easingFunction = options.getMember("easing");
        this.transitionStartTime = System.currentTimeMillis();
        this.isAnimating = true;
    }

    @HostAccess.Export
    public void snapTo(Value options) {
        if (!this.isCustomCameraActive() || !options.hasMembers()) {
            return;
        }
        this.isAnimating = false;
        if (options.hasMember("position")) {
            Value pos = options.getMember("position");
            this.currentState.position.set(pos.getMember("x").asDouble(), pos.getMember("y").asDouble(), pos.getMember("z").asDouble());
        }
        if (options.hasMember("yaw")) {
            this.currentState.yaw = options.getMember("yaw").asDouble();
        }
        if (options.hasMember("pitch")) {
            this.currentState.pitch = options.getMember("pitch").asDouble();
        }
        if (options.hasMember("roll")) {
            this.currentState.roll = options.getMember("roll").asDouble();
        }
        if (options.hasMember("fov")) {
            this.currentState.fov = options.getMember("fov").asDouble();
        }
        this.targetState.position.set((Vector3dc)this.currentState.position);
        this.targetState.yaw = this.currentState.yaw;
        this.targetState.pitch = this.currentState.pitch;
        this.targetState.roll = this.currentState.roll;
        this.targetState.fov = this.currentState.fov;
    }

    public Vector3d getPosition() {
        return this.isCustomCameraActive() ? this.currentState.position : null;
    }

    public Float getYaw() {
        return this.isCustomCameraActive() ? Float.valueOf((float)this.currentState.yaw) : null;
    }

    public Float getPitch() {
        return this.isCustomCameraActive() ? Float.valueOf((float)this.currentState.pitch) : null;
    }

    public Float getRoll() {
        return this.isCustomCameraActive() ? Float.valueOf((float)this.currentState.roll) : null;
    }

    public Double getFovInternal() {
        return this.isCustomCameraActive() ? Double.valueOf(this.currentState.fov) : null;
    }

    public boolean shouldDisableViewBobbing() {
        return this.isCustomCameraActive();
    }

    @HostAccess.Export
    public boolean isCustomCameraActive() {
        return MoudClientMod.isCustomCameraActive();
    }

    @HostAccess.Export
    public double getPlayerX() {
        class_1297 cameraEntity = this.client.method_1560();
        return cameraEntity != null ? cameraEntity.method_23317() : 0.0;
    }

    @HostAccess.Export
    public double getPlayerY() {
        class_1297 cameraEntity = this.client.method_1560();
        return cameraEntity != null ? cameraEntity.method_23320() : 0.0;
    }

    @HostAccess.Export
    public double getPlayerZ() {
        class_1297 cameraEntity = this.client.method_1560();
        return cameraEntity != null ? cameraEntity.method_23321() : 0.0;
    }

    @HostAccess.Export
    public float getPlayerYaw() {
        class_1297 cameraEntity = this.client.method_1560();
        return cameraEntity != null ? cameraEntity.method_36454() : 0.0f;
    }

    @HostAccess.Export
    public float getPlayerPitch() {
        class_1297 cameraEntity = this.client.method_1560();
        return cameraEntity != null ? cameraEntity.method_36455() : 0.0f;
    }

    @HostAccess.Export
    public Vector3 createVector3(double x, double y, double z) {
        return new Vector3(x, y, z);
    }

    @HostAccess.Export
    public boolean isThirdPerson() {
        return this.client.field_1690.method_31044() != class_5498.field_26664;
    }

    @HostAccess.Export
    public void setThirdPerson(boolean thirdPerson) {
        boolean isCurrentlyThirdPerson;
        class_5498 current = this.client.field_1690.method_31044();
        boolean bl = isCurrentlyThirdPerson = current != class_5498.field_26664;
        if (thirdPerson && !isCurrentlyThirdPerson) {
            this.client.field_1690.method_31043(class_5498.field_26665);
        } else if (!thirdPerson && isCurrentlyThirdPerson) {
            this.client.field_1690.method_31043(class_5498.field_26664);
        }
    }

    @HostAccess.Export
    public double getFov() {
        return ((Integer)this.client.field_1690.method_41808().method_41753()).intValue();
    }

    public void cleanUp() {
        this.jsContext = null;
        if (MoudClientMod.isCustomCameraActive()) {
            this.disableCustomCamera();
        }
        LOGGER.info("CameraService cleaned up.");
    }

    private static class CameraState {
        public Vector3d position = new Vector3d();
        public double yaw = 0.0;
        public double pitch = 0.0;
        public double roll = 0.0;
        public double fov = 70.0;

        private CameraState() {
        }
    }
}

