/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.api.service;

import com.moud.client.api.service.CameraService;
import com.moud.client.api.service.ConsoleAPI;
import com.moud.client.api.service.CursorService;
import com.moud.client.api.service.EventService;
import com.moud.client.api.service.InputService;
import com.moud.client.api.service.LightingService;
import com.moud.client.api.service.NetworkService;
import com.moud.client.api.service.RenderingService;
import com.moud.client.api.service.UIService;
import com.moud.client.runtime.ClientScriptingRuntime;
import com.moud.client.shared.api.ClientSharedApiProxy;
import com.moud.client.update.ClientUpdateManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graalvm.polyglot.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientAPIService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientAPIService.class);
    public static ClientAPIService INSTANCE;
    public final NetworkService network;
    public final RenderingService rendering;
    public final UIService ui;
    public final ConsoleAPI console;
    public final CursorService cursor;
    public final CameraService camera;
    public final LightingService lighting;
    public final ClientSharedApiProxy shared;
    private final ClientUpdateManager updateManager;
    public final EventService events;
    public InputService input;
    ClientScriptingRuntime scriptingRuntime;
    private final AtomicBoolean contextUpdated = new AtomicBoolean(false);

    public ClientAPIService() {
        if (INSTANCE != null) {
            LOGGER.warn("ClientAPIService is being instantiated more than once. This may lead to unexpected behavior.");
        }
        INSTANCE = this;
        this.network = new NetworkService();
        this.rendering = new RenderingService();
        this.ui = new UIService();
        this.cursor = new CursorService();
        this.console = new ConsoleAPI();
        this.camera = new CameraService();
        this.lighting = new LightingService();
        this.shared = new ClientSharedApiProxy();
        this.events = new EventService(this);
        this.network.setLightingService(this.lighting);
        this.updateManager = new ClientUpdateManager(this);
        LOGGER.info("ClientAPIService partially initialized. Waiting for scripting runtime...");
    }

    public void setRuntime(ClientScriptingRuntime runtime) {
        if (this.scriptingRuntime != null) {
            LOGGER.warn("Scripting runtime is being set more than once.");
            return;
        }
        this.scriptingRuntime = runtime;
        this.input = new InputService(runtime);
        LOGGER.info("InputService initialized.");
        if (runtime != null && runtime.isInitialized()) {
            runtime.updateMoudBindings();
        }
    }

    public void updateScriptingContext(Context context) {
        if (context == null) {
            LOGGER.warn("Attempted to update with null context");
            this.contextUpdated.set(false);
            return;
        }
        try {
            this.network.setContext(context);
            this.rendering.setContext(context);
            this.ui.setContext(context);
            this.ui.setExecutor(this.scriptingRuntime != null ? this.scriptingRuntime.getExecutor() : null);
            this.console.setContext(context);
            this.camera.setContext(context);
            this.lighting.setContext(context);
            this.events.setContext(context);
            if (this.input != null) {
                this.input.setContext(context);
                if (this.scriptingRuntime != null) {
                    this.scriptingRuntime.updateMoudBindings();
                }
            } else {
                LOGGER.warn("Attempted to update script context before InputService was initialized.");
            }
            this.contextUpdated.set(true);
            LOGGER.debug("ClientAPIService updated scripting context for all child services.");
        }
        catch (Exception e) {
            LOGGER.error("Failed to update scripting context", (Throwable)e);
            this.contextUpdated.set(false);
        }
    }

    public boolean isContextValid() {
        return this.contextUpdated.get();
    }

    public void cleanup() {
        this.contextUpdated.set(false);
        try {
            if (this.network != null) {
                this.network.cleanUp();
            }
            if (this.rendering != null) {
                this.rendering.cleanUp();
            }
            if (this.ui != null) {
                this.ui.cleanUp();
            }
            if (this.console != null) {
                this.console.cleanUp();
            }
            if (this.camera != null) {
                this.camera.cleanUp();
            }
            if (this.cursor != null) {
                this.cursor.cleanUp();
            }
            if (this.lighting != null) {
                this.lighting.cleanUp();
            }
            if (this.input != null) {
                this.input.cleanUp();
            }
            if (this.updateManager != null) {
                this.updateManager.cleanup();
            }
            if (this.events != null) {
                this.events.cleanUp();
            }
            this.scriptingRuntime = null;
            LOGGER.info("ClientAPIService cleaned up all child services.");
        }
        catch (Exception e) {
            LOGGER.error("Error during cleanup", (Throwable)e);
        }
    }

    public ClientUpdateManager getUpdateManager() {
        return this.updateManager;
    }
}

