/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.api.service;

import net.minecraft.class_310;
import net.minecraft.class_437;
import org.graalvm.polyglot.HostAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CursorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CursorService.class);
    private final class_310 client = class_310.method_1551();
    private boolean isVisible = false;
    private boolean forceHidden = false;
    private boolean wasInGame = false;
    private boolean manualControl = false;

    @HostAccess.Export
    public void show() {
        if (!this.isVisible) {
            this.isVisible = true;
            this.forceHidden = false;
            this.manualControl = true;
            this.client.execute(() -> {
                if (this.client.field_1729 != null) {
                    this.client.field_1729.method_1610();
                }
            });
            LOGGER.debug("Cursor shown.");
        }
    }

    @HostAccess.Export
    public void hide() {
        if (this.isVisible || !this.forceHidden) {
            this.isVisible = false;
            this.forceHidden = true;
            this.manualControl = true;
            this.client.execute(() -> {
                if (this.client.field_1729 != null) {
                    this.client.field_1729.method_1612();
                }
            });
            LOGGER.debug("Cursor hidden.");
        }
    }

    @HostAccess.Export
    public void toggle() {
        if (this.isVisible) {
            this.hide();
        } else {
            this.show();
        }
    }

    @HostAccess.Export
    public boolean isVisible() {
        return this.isVisible;
    }

    public void tick() {
        boolean inGame;
        if (this.manualControl) {
            return;
        }
        if (this.client.field_1687 == null) {
            return;
        }
        boolean bl = inGame = this.client.field_1755 == null;
        if (this.forceHidden && inGame && this.client.field_1729 != null && !this.client.field_1729.method_1613()) {
            this.client.execute(() -> this.client.field_1729.method_1612());
        }
        if (!this.wasInGame && inGame && this.forceHidden) {
            this.client.execute(() -> {
                if (this.client.field_1729 != null) {
                    this.client.field_1729.method_1612();
                }
            });
        }
        this.wasInGame = inGame;
    }

    public void onScreenOpen(class_437 screen) {
        if (screen != null && this.forceHidden) {
            this.client.execute(() -> {
                if (this.client.field_1729 != null) {
                    this.client.field_1729.method_1610();
                }
            });
        }
    }

    public void onScreenClose() {
        if (this.forceHidden) {
            this.client.execute(() -> {
                if (this.client.field_1729 != null) {
                    this.client.field_1729.method_1612();
                }
            });
        }
    }

    public void onFocusGained() {
        if (this.forceHidden && this.client.field_1755 == null) {
            this.client.execute(() -> {
                if (this.client.field_1729 != null) {
                    this.client.field_1729.method_1612();
                }
            });
        }
    }

    public void cleanUp() {
        if (this.isVisible) {
            this.hide();
        }
        this.forceHidden = false;
        this.manualControl = false;
        LOGGER.info("CursorService cleaned up.");
    }
}

