/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.api.service;

import com.moud.client.api.service.ClientAPIService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventService.class);
    private final Map<String, List<Value>> handlers = new ConcurrentHashMap<String, List<Value>>();
    private final ClientAPIService apiService;
    private Context jsContext;
    private ExecutorService scriptExecutor;

    public EventService(ClientAPIService apiService) {
        this.apiService = apiService;
    }

    public void setContext(Context context) {
        this.jsContext = context;
        if (this.apiService.scriptingRuntime != null) {
            this.scriptExecutor = this.apiService.scriptingRuntime.getExecutor();
        }
    }

    @HostAccess.Export
    public void on(String eventName, Value callback) {
        if (callback == null || !callback.canExecute()) {
            throw new IllegalArgumentException("Event handler must be an executable function.");
        }
        this.handlers.computeIfAbsent(eventName, k -> new CopyOnWriteArrayList()).add(callback);
        LOGGER.debug("Registered client-side event handler for '{}'", (Object)eventName);
    }

    @HostAccess.Export
    public void dispatch(String eventName, Object ... args) {
        List<Value> callbacks = this.handlers.get(eventName);
        if (callbacks == null || callbacks.isEmpty()) {
            if ("core:scriptsReceived".equals(eventName) && args.length > 0) {
                if (class_310.method_1551().field_1724 != null) {
                    class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)args[0].toString()), false);
                }
                return;
            }
            return;
        }
        if (this.scriptExecutor == null || this.scriptExecutor.isShutdown() || this.jsContext == null) {
            LOGGER.warn("Cannot dispatch event '{}': script runtime is not ready.", (Object)eventName);
            return;
        }
        for (Value callback : callbacks) {
            this.scriptExecutor.execute(() -> {
                try {
                    this.jsContext.enter();
                    callback.execute(args);
                }
                catch (Exception e) {
                    LOGGER.error("Error executing event handler for '{}'", (Object)eventName, (Object)e);
                }
                finally {
                    try {
                        this.jsContext.leave();
                    }
                    catch (Exception exception) {}
                }
            });
        }
    }

    public void cleanUp() {
        this.handlers.clear();
        this.jsContext = null;
        this.scriptExecutor = null;
        LOGGER.info("EventService cleaned up.");
    }
}

