/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.api.service;

import com.moud.client.camera.CameraManager;
import com.moud.client.runtime.ClientScriptingRuntime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InputService {
    private final class_310 client;
    private final Map<String, Value> keyCallbacks = new ConcurrentHashMap<String, Value>();
    private final Map<String, Value> mouseCallbacks = new ConcurrentHashMap<String, Value>();
    private Value mouseMoveCallback;
    private Value scrollCallback;
    private double lastMouseX;
    private double lastMouseY;
    private double mouseDeltaX;
    private double mouseDeltaY;
    private static final Logger LOGGER = LoggerFactory.getLogger(InputService.class);
    private Context jsContext;
    private final ExecutorService scriptExecutor;
    private final Map<String, Boolean> keyStates = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Long> lastKeyTriggerTime = new ConcurrentHashMap<String, Long>();
    private static final long DEBOUNCE_TIME_MS = 100L;

    public InputService(ClientScriptingRuntime runtime) {
        this.client = class_310.method_1551();
        this.scriptExecutor = runtime.getExecutor();
    }

    public void setContext(Context jsContext) {
        this.jsContext = jsContext;
        LOGGER.debug("InputService received new GraalVM Context.");
    }

    public boolean handleKeyEvent(int key, int action) {
        String keyName;
        boolean wasPressed;
        if (key == -1) {
            return false;
        }
        boolean isPressed = action == 1;
        if (isPressed == (wasPressed = this.keyStates.getOrDefault(keyName = class_3675.method_15985((int)key, (int)-1).method_1441(), false).booleanValue())) {
            return false;
        }
        this.keyStates.put(keyName, isPressed);
        boolean hasCallback = this.keyCallbacks.containsKey(keyName);
        if (hasCallback) {
            this.triggerKeyEvent(keyName, isPressed);
        }
        return hasCallback;
    }

    @HostAccess.Export
    public boolean isKeyPressed(int keyCode) {
        long window = this.client.method_22683().method_4490();
        return GLFW.glfwGetKey((long)window, (int)keyCode) == 1;
    }

    @HostAccess.Export
    public boolean isKeyPressed(String keyName) {
        try {
            class_3675.class_306 key = class_3675.method_15981((String)keyName);
            return this.isKeyPressed(key.method_1444());
        }
        catch (Exception e) {
            return false;
        }
    }

    @HostAccess.Export
    public boolean isMouseButtonPressed(int button) {
        long window = this.client.method_22683().method_4490();
        return GLFW.glfwGetMouseButton((long)window, (int)button) == 1;
    }

    @HostAccess.Export
    public double getMouseX() {
        return this.client.field_1729.method_1603();
    }

    @HostAccess.Export
    public double getMouseY() {
        return this.client.field_1729.method_1604();
    }

    @HostAccess.Export
    public double getMouseDeltaX() {
        return this.mouseDeltaX;
    }

    @HostAccess.Export
    public double getMouseDeltaY() {
        return this.mouseDeltaY;
    }

    @HostAccess.Export
    public void onKey(String keyName, Value callback) {
        if (callback == null || !callback.canExecute()) {
            throw new IllegalArgumentException("Callback must be executable");
        }
        this.keyCallbacks.put(keyName, callback);
        LOGGER.info("Successfully registered key callback for: {}", (Object)keyName);
    }

    @HostAccess.Export
    public void onMouseButton(String buttonName, Value callback) {
        if (callback == null || !callback.canExecute()) {
            throw new IllegalArgumentException("Callback must be executable");
        }
        this.mouseCallbacks.put(buttonName, callback);
    }

    @HostAccess.Export
    public void onMouseMove(Value callback) {
        if (callback == null || !callback.canExecute()) {
            throw new IllegalArgumentException("Callback must be executable");
        }
        this.mouseMoveCallback = callback;
    }

    @HostAccess.Export
    public void onScroll(Value callback) {
        if (callback == null || !callback.canExecute()) {
            throw new IllegalArgumentException("Callback must be executable");
        }
        this.scrollCallback = callback;
    }

    @HostAccess.Export
    public boolean isMovingForward() {
        return this.client.field_1690.field_1894.method_1434();
    }

    @HostAccess.Export
    public boolean isMovingBackward() {
        return this.client.field_1690.field_1881.method_1434();
    }

    @HostAccess.Export
    public boolean isStrafingLeft() {
        return this.client.field_1690.field_1913.method_1434();
    }

    @HostAccess.Export
    public boolean isStrafingRight() {
        return this.client.field_1690.field_1849.method_1434();
    }

    @HostAccess.Export
    public boolean isJumping() {
        return this.client.field_1690.field_1903.method_1434();
    }

    @HostAccess.Export
    public boolean isSprinting() {
        return this.client.field_1724 != null && this.client.field_1724.method_5624();
    }

    @HostAccess.Export
    public boolean isOnGround() {
        return this.client.field_1724 != null && this.client.field_1724.method_24828();
    }

    @HostAccess.Export
    public boolean isMoving() {
        return this.isMovingForward() || this.isMovingBackward() || this.isStrafingLeft() || this.isStrafingRight();
    }

    public void triggerKeyEvent(String keyName, boolean pressed) {
        Value callback = this.keyCallbacks.get(keyName);
        if (callback != null) {
            long currentTime = System.currentTimeMillis();
            Long lastTrigger = this.lastKeyTriggerTime.get(keyName);
            if (lastTrigger != null && currentTime - lastTrigger < 100L) {
                return;
            }
            this.lastKeyTriggerTime.put(keyName, currentTime);
            this.scriptExecutor.execute(() -> {
                if (this.jsContext == null) {
                    LOGGER.warn("jsContext is null, cannot execute key event for {}", (Object)keyName);
                    return;
                }
                this.jsContext.enter();
                try {
                    if (callback.canExecute()) {
                        callback.execute(new Object[]{pressed});
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error executing script key event callback for '{}'", (Object)keyName, (Object)e);
                }
                finally {
                    this.jsContext.leave();
                }
            });
        }
    }

    public void triggerMouseButtonEvent(String buttonName, boolean pressed) {
        Value callback = this.mouseCallbacks.get(buttonName);
        if (callback != null) {
            this.executeCallback(callback, buttonName, pressed);
        }
    }

    public void triggerMouseMoveEvent(double deltaX, double deltaY) {
        if (CameraManager.isCameraActive()) {
            CameraManager.handleInput(deltaX, deltaY, 0.0);
        }
        if (this.mouseMoveCallback != null) {
            this.executeCallback(this.mouseMoveCallback, deltaX, deltaY);
        }
    }

    public boolean triggerScrollEvent(double scrollDelta) {
        if (this.scrollCallback != null) {
            this.executeCallback(this.scrollCallback, scrollDelta);
            return true;
        }
        return false;
    }

    private void executeCallback(Value callback, Object ... args) {
        if (this.scriptExecutor == null || this.scriptExecutor.isShutdown() || this.jsContext == null) {
            return;
        }
        this.scriptExecutor.execute(() -> {
            this.jsContext.enter();
            try {
                if (callback.canExecute()) {
                    callback.execute(args);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error executing script callback", (Throwable)e);
            }
            finally {
                this.jsContext.leave();
            }
        });
    }

    @HostAccess.Export
    public void lockMouse(boolean locked) {
        GLFW.glfwSetInputMode((long)this.client.method_22683().method_4490(), (int)208897, (int)(locked ? 212995 : 212993));
    }

    @HostAccess.Export
    public boolean isMouseLocked() {
        return GLFW.glfwGetInputMode((long)this.client.method_22683().method_4490(), (int)208897) == 212995;
    }

    @HostAccess.Export
    public double getMouseSensitivity() {
        return (Double)this.client.field_1690.method_42495().method_41753();
    }

    @HostAccess.Export
    public void setMouseSensitivity(float sensitivity) {
        this.client.field_1690.method_42495().method_41748((Object)sensitivity);
    }

    public void update() {
    }

    public void cleanUp() {
        this.keyCallbacks.clear();
        this.mouseCallbacks.clear();
        this.mouseMoveCallback = null;
        this.scrollCallback = null;
        this.jsContext = null;
        this.keyStates.clear();
        this.lastKeyTriggerTime.clear();
        LOGGER.info("InputService cleaned up.");
    }
}

