/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.api.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moud.api.math.Conversion;
import com.moud.client.lighting.ClientLightingService;
import java.util.Map;
import net.minecraft.class_310;
import org.graalvm.polyglot.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightingService.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final ClientLightingService internalLightingService = ClientLightingService.getInstance();
    private Context jsContext;

    public LightingService() {
        this.internalLightingService.initialize();
        LOGGER.debug("LightingService (wrapper) obtained singleton instance.");
    }

    public void setContext(Context jsContext) {
        this.jsContext = jsContext;
    }

    public void handleNetworkEvent(String eventName, String eventData) {
        class_310.method_1551().execute(() -> {
            LOGGER.debug("Handling lighting event on client thread: {}", (Object)eventName);
            try {
                Map data = (Map)MAPPER.readValue(eventData, MAP_TYPE_REFERENCE);
                block5 : switch (eventName) {
                    case "lighting:operation": {
                        String operation = (String)data.get("operation");
                        Map lightData = (Map)data.get("light");
                        if (operation == null || lightData == null) {
                            LOGGER.warn("Invalid lighting operation data.");
                            return;
                        }
                        switch (operation) {
                            case "create": 
                            case "update": {
                                this.internalLightingService.handleCreateOrUpdateLight(lightData);
                                break block5;
                            }
                            case "remove": {
                                long id = Conversion.toLong(lightData.get("id"));
                                this.internalLightingService.handleRemoveLight(id);
                                break block5;
                            }
                        }
                        LOGGER.warn("Unknown lighting operation: {}", (Object)operation);
                        break;
                    }
                    case "lighting:sync": {
                        this.internalLightingService.handleLightSync(data);
                        break;
                    }
                    default: {
                        LOGGER.warn("Unknown lighting event: {}", (Object)eventName);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to handle lighting network event: {} with data: {}", new Object[]{eventName, eventData, e});
            }
        });
    }

    public void tick() {
        this.internalLightingService.tick();
    }

    public void cleanUp() {
        this.internalLightingService.cleanup();
        this.jsContext = null;
        LOGGER.debug("LightingService wrapper cleaned up for session.");
    }
}

