/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.api.service;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.moud.client.api.service.LightingService;
import com.moud.client.network.ClientNetworkManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkService.class);
    private static final Gson GSON = new Gson();
    private final Map<String, Value> eventHandlers = new ConcurrentHashMap<String, Value>();
    private Context jsContext;
    private LightingService lightingService;

    public void setContext(Context jsContext) {
        this.jsContext = jsContext;
        LOGGER.debug("NetworkService received new GraalVM Context.");
    }

    public void setLightingService(LightingService lightingService) {
        this.lightingService = lightingService;
    }

    @HostAccess.Export
    public void sendToServer(String eventName, Object data) {
        String serializedData = this.serializeData(data);
        ClientNetworkManager.sendToServer(eventName, serializedData);
    }

    @HostAccess.Export
    public void on(String eventName, Value callback) {
        this.validateCallback(callback);
        this.eventHandlers.put(eventName, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void triggerEvent(String eventName, String eventData) {
        if (eventName.startsWith("lighting:") && this.lightingService != null) {
            this.lightingService.handleNetworkEvent(eventName, eventData);
            return;
        }
        Value handler = this.eventHandlers.get(eventName);
        if (handler == null || !handler.canExecute()) return;
        if (this.jsContext != null) {
            this.jsContext.enter();
            try {
                Object finalData;
                if (eventData == null || eventData.isEmpty()) {
                    finalData = null;
                } else {
                    try {
                        finalData = GSON.fromJson(eventData, Object.class);
                    }
                    catch (JsonSyntaxException e) {
                        LOGGER.warn("Failed to parse JSON for event '{}'. Passing raw string instead. JSON: {}", new Object[]{eventName, eventData, e});
                        finalData = eventData;
                    }
                }
                handler.execute(new Object[]{finalData});
                return;
            }
            catch (PolyglotException e) {
                LOGGER.error("Error executing JavaScript network handler for event '{}': {}", (Object)eventName, (Object)e.getMessage());
                if (!e.isGuestException()) return;
                LOGGER.error("Guest stack trace:\n{}", (Object)e.getStackTrace());
                return;
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error executing JavaScript network handler for event '{}'", (Object)eventName, (Object)e);
                return;
            }
            finally {
                this.jsContext.leave();
            }
        }
        LOGGER.warn("Cannot trigger network event '{}': JavaScript context is not initialized in NetworkService.", (Object)eventName);
    }

    private void validateCallback(Value callback) {
        if (!callback.canExecute()) {
            throw new IllegalArgumentException("Callback must be executable");
        }
    }

    private String serializeData(Object data) {
        if (data == null) {
            return "";
        }
        return data.toString();
    }

    public void cleanUp() {
        this.eventHandlers.clear();
        this.jsContext = null;
        this.lightingService = null;
        LOGGER.info("NetworkService cleaned up.");
    }
}

