/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.api.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2960;
import org.graalvm.polyglot.Value;

public record RenderTypeDefinition(class_2960 shader, List<class_2960> textures, String transparency, boolean cull, boolean lightmap, boolean depthTest) {
    public RenderTypeDefinition(Value options) {
        this(RenderTypeDefinition.parseShader(options), RenderTypeDefinition.parseTextures(options), RenderTypeDefinition.parseTransparency(options), RenderTypeDefinition.parseBoolean(options, "cull", true), RenderTypeDefinition.parseBoolean(options, "lightmap", false), RenderTypeDefinition.parseBoolean(options, "depthTest", true));
    }

    private static class_2960 parseShader(Value options) {
        if (!options.hasMember("shader")) {
            throw new IllegalArgumentException("Shader is required");
        }
        String shaderStr = options.getMember("shader").asString();
        return class_2960.method_12829((String)shaderStr);
    }

    private static List<class_2960> parseTextures(Value options) {
        Value texturesValue;
        ArrayList<class_2960> textures = new ArrayList<class_2960>();
        if (options.hasMember("textures") && (texturesValue = options.getMember("textures")).hasArrayElements()) {
            long size = texturesValue.getArraySize();
            for (long i = 0L; i < size; ++i) {
                String textureStr = texturesValue.getArrayElement(i).asString();
                class_2960 texture = class_2960.method_12829((String)textureStr);
                if (texture == null) continue;
                textures.add(texture);
            }
        }
        return textures;
    }

    private static String parseTransparency(Value options) {
        if (options.hasMember("transparency")) {
            return options.getMember("transparency").asString();
        }
        return "opaque";
    }

    private static boolean parseBoolean(Value options, String key, boolean defaultValue) {
        if (options.hasMember(key)) {
            return options.getMember(key).asBoolean();
        }
        return defaultValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RenderTypeDefinition that = (RenderTypeDefinition)obj;
        return this.cull == that.cull && this.lightmap == that.lightmap && this.depthTest == that.depthTest && Objects.equals(this.shader, that.shader) && Objects.equals(this.textures, that.textures) && Objects.equals(this.transparency, that.transparency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.shader, this.textures, this.transparency, this.cull, this.lightmap, this.depthTest);
    }
}

