/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.api.service;

import com.moud.client.api.service.RenderTypeDefinition;
import com.moud.client.rendering.CustomRenderTypeManager;
import com.moud.client.rendering.PostProcessingManager;
import com.moud.client.runtime.ClientScriptingRuntime;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RenderingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderingService.class);
    private final PostProcessingManager postProcessingManager = new PostProcessingManager();
    private final CustomRenderTypeManager renderTypeManager = new CustomRenderTypeManager();
    private final Map<String, Value> renderHandlers = new ConcurrentHashMap<String, Value>();
    private final Map<String, Value> animationFrameCallbacks = new ConcurrentHashMap<String, Value>();
    private final Map<class_2960, Map<String, Object>> pendingUniformUpdates = new ConcurrentHashMap<class_2960, Map<String, Object>>();
    private final Queue<Consumer<Double>> pendingJavaCallbacks = new ConcurrentLinkedQueue<Consumer<Double>>();
    private ClientScriptingRuntime scriptingRuntime;
    private volatile Context jsContext;
    private final AtomicBoolean contextValid = new AtomicBoolean(false);

    public void setRuntime(ClientScriptingRuntime runtime) {
        this.scriptingRuntime = runtime;
    }

    public void setContext(Context jsContext) {
        this.jsContext = jsContext;
        this.contextValid.set(jsContext != null);
        LOGGER.debug("RenderingService received new GraalVM Context, valid: {}", (Object)this.contextValid.get());
        if (this.contextValid.get() && !this.pendingJavaCallbacks.isEmpty()) {
            this.processPendingJavaCallbacks();
        }
    }

    private void processPendingJavaCallbacks() {
        if (this.scriptingRuntime == null || this.scriptingRuntime.getExecutor() == null || this.scriptingRuntime.getExecutor().isShutdown()) {
            return;
        }
        this.scriptingRuntime.getExecutor().execute(() -> {
            if (!this.contextValid.get() || this.jsContext == null) {
                return;
            }
            int processed = 0;
            while (!this.pendingJavaCallbacks.isEmpty()) {
                Consumer<Double> callback = this.pendingJavaCallbacks.poll();
                if (callback == null) continue;
                this.registerJavaCallbackDirectly(callback);
                ++processed;
            }
            if (processed > 0) {
                LOGGER.info("Processed {} pending Java animation frame callbacks", (Object)processed);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerJavaCallbackDirectly(Consumer<Double> javaCallback) {
        if (!this.contextValid.get() || this.jsContext == null) {
            LOGGER.warn("Context became invalid while processing pending callbacks");
            return;
        }
        String id = "raf_java_" + System.nanoTime();
        try {
            this.jsContext.enter();
            ProxyExecutable proxy = args -> {
                javaCallback.accept(args.length > 0 ? args[0].asDouble() : 0.0);
                return null;
            };
            Value callbackValue = Value.asValue((Object)proxy);
            if (callbackValue.canExecute()) {
                this.animationFrameCallbacks.put(id, callbackValue);
                LOGGER.debug("Registered pending callback with id: {}", (Object)id);
            } else {
                LOGGER.error("Failed to create executable Value from Java proxy");
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while creating animation frame proxy", (Throwable)e);
        }
        finally {
            this.jsContext.leave();
        }
    }

    @HostAccess.Export
    public String requestAnimationFrame(Value callback) {
        if (!callback.canExecute()) {
            throw new IllegalArgumentException("Callback must be an executable function");
        }
        String id = "raf_" + System.nanoTime();
        this.animationFrameCallbacks.put(id, callback);
        return id;
    }

    @HostAccess.Export
    public void cancelAnimationFrame(String id) {
        this.animationFrameCallbacks.remove(id);
    }

    @HostAccess.Export
    public String createRenderType(Value options) {
        try {
            RenderTypeDefinition definition = new RenderTypeDefinition(options);
            class_2960 renderTypeId = this.renderTypeManager.getOrCreate(definition);
            return renderTypeId.toString();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create render type", (Throwable)e);
            throw new RuntimeException("Failed to create render type", e);
        }
    }

    @HostAccess.Export
    public void setShaderUniform(String shaderId, String uniformName, Object value) {
        try {
            class_2960 shaderIdentifier = class_2960.method_12829((String)shaderId);
            if (shaderIdentifier == null) {
                LOGGER.error("Invalid shader ID format: {}", (Object)shaderId);
                return;
            }
            this.pendingUniformUpdates.computeIfAbsent(shaderIdentifier, k -> new ConcurrentHashMap()).put(uniformName, value);
        }
        catch (Exception e) {
            LOGGER.error("Failed to queue shader uniform update", (Throwable)e);
        }
    }

    public void applyPendingUniforms() {
        if (this.pendingUniformUpdates.isEmpty()) {
            return;
        }
        try {
            this.pendingUniformUpdates.forEach((shaderId, uniforms) -> {
                try {
                    ShaderProgram shader = VeilRenderSystem.setShader((class_2960)shaderId);
                    if (shader != null) {
                        uniforms.forEach((uniformName, value) -> {
                            try {
                                ShaderUniform uniform = shader.getUniform((CharSequence)uniformName);
                                if (uniform != null) {
                                    if (value instanceof Number) {
                                        Number number = (Number)value;
                                        if (value instanceof Float || value instanceof Double) {
                                            uniform.setFloat(number.floatValue());
                                        } else {
                                            uniform.setInt(number.intValue());
                                        }
                                    } else if (value instanceof Boolean) {
                                        Boolean bool = (Boolean)value;
                                        uniform.setInt(bool != false ? 1 : 0);
                                    }
                                }
                            }
                            catch (Exception e) {
                                LOGGER.error("Failed to set uniform {} on shader {}", new Object[]{uniformName, shaderId, e});
                            }
                        });
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to update shader uniforms for {}", shaderId, (Object)e);
                }
            });
            this.pendingUniformUpdates.clear();
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply pending uniform updates", (Throwable)e);
        }
    }

    public void triggerRenderEvents() {
        if (!this.contextValid.get()) {
            return;
        }
        double timestamp = (double)System.nanoTime() / 1000000.0;
        this.triggerRenderEvent("beforeWorldRender", timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAnimationFrames(double timestamp) {
        if (this.animationFrameCallbacks.isEmpty() || !this.contextValid.get()) {
            return;
        }
        ConcurrentHashMap<String, Value> currentCallbacks = new ConcurrentHashMap<String, Value>(this.animationFrameCallbacks);
        this.animationFrameCallbacks.clear();
        if (this.jsContext == null) {
            return;
        }
        try {
            this.jsContext.enter();
            for (Value callback : currentCallbacks.values()) {
                if (!callback.canExecute()) continue;
                callback.execute(new Object[]{timestamp});
            }
        }
        catch (Exception e) {
            LOGGER.error("Error executing animation frame callbacks", (Throwable)e);
        }
        finally {
            this.jsContext.leave();
        }
    }

    public void triggerRenderEvent(String eventName, Object data) {
        Value handler = this.renderHandlers.get(eventName);
        if (handler == null || !this.contextValid.get()) {
            return;
        }
        if (this.scriptingRuntime == null || !this.scriptingRuntime.isInitialized()) {
            return;
        }
        this.scriptingRuntime.getExecutor().execute(() -> {
            if (this.jsContext == null || !this.contextValid.get()) {
                this.contextValid.set(false);
                return;
            }
            try {
                this.jsContext.enter();
                try {
                    if (handler.canExecute()) {
                        handler.execute(new Object[]{data});
                    }
                }
                finally {
                    this.jsContext.leave();
                }
            }
            catch (IllegalStateException e) {
                if (e.getMessage() != null && (e.getMessage().contains("Context is already closed") || e.getMessage().contains("not entered explicitly") || e.getMessage().contains("Multi threaded access"))) {
                    LOGGER.debug("Context access error during render event execution: {}", (Object)e.getMessage());
                    this.contextValid.set(false);
                } else {
                    LOGGER.error("State error executing render handler for event '{}'", (Object)eventName, (Object)e);
                }
            }
            catch (PolyglotException e) {
                LOGGER.error("Error executing JavaScript render handler for event '{}': {}", (Object)eventName, (Object)e.getMessage());
                if (e.isGuestException()) {
                    LOGGER.error("Guest stack trace:", (Throwable)e);
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error executing JavaScript render handler for event '{}'", (Object)eventName, (Object)e);
            }
        });
    }

    public void cleanUp() {
        this.contextValid.set(false);
        this.postProcessingManager.clearAllEffects();
        this.renderTypeManager.clearCache();
        this.renderHandlers.clear();
        this.animationFrameCallbacks.clear();
        this.pendingUniformUpdates.clear();
        this.pendingJavaCallbacks.clear();
        this.scriptingRuntime = null;
        this.jsContext = null;
        LOGGER.info("RenderingService cleaned up");
    }
}

