/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.api.service;

import com.moud.client.ui.UIOverlayManager;
import com.moud.client.ui.component.UIButton;
import com.moud.client.ui.component.UIComponent;
import com.moud.client.ui.component.UIContainer;
import com.moud.client.ui.component.UIImage;
import com.moud.client.ui.component.UIInput;
import com.moud.client.ui.component.UIText;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import net.minecraft.class_310;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UIService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UIService.class);
    private final class_310 client;
    private final UIOverlayManager overlayManager;
    private final Map<String, UIComponent> elements = new ConcurrentHashMap<String, UIComponent>();
    private Context jsContext;
    private ExecutorService scriptExecutor;
    private Value resizeCallback = null;

    public UIService() {
        this.client = class_310.method_1551();
        this.overlayManager = UIOverlayManager.getInstance();
    }

    public void setContext(Context jsContext) {
        this.jsContext = jsContext;
    }

    public void setExecutor(ExecutorService executor) {
        this.scriptExecutor = executor;
    }

    public Context getJsContext() {
        return this.jsContext;
    }

    public ExecutorService getScriptExecutor() {
        return this.scriptExecutor;
    }

    @HostAccess.Export
    public int getScreenWidth() {
        return this.client.method_22683().method_4486();
    }

    @HostAccess.Export
    public int getScreenHeight() {
        return this.client.method_22683().method_4502();
    }

    @HostAccess.Export
    public int getMouseX() {
        return (int)(this.client.field_1729.method_1603() * (double)this.getScreenWidth() / (double)this.client.method_22683().method_4480());
    }

    @HostAccess.Export
    public int getMouseY() {
        return (int)(this.client.field_1729.method_1604() * (double)this.getScreenHeight() / (double)this.client.method_22683().method_4507());
    }

    @HostAccess.Export
    public int getTextWidth(String text) {
        if (text == null) {
            return 0;
        }
        return this.client.field_1772.method_1727(text);
    }

    private <T extends UIComponent> T registerComponent(T component) {
        String id = "moud_ui_" + UUID.randomUUID().toString();
        component.setComponentId(id);
        this.elements.put(id, component);
        this.overlayManager.addOverlayElement(component);
        return component;
    }

    @HostAccess.Export
    public UIText createText(String content) {
        UIText text = new UIText(content, this);
        double d = this.client.field_1772.method_1727(content);
        Objects.requireNonNull(this.client.field_1772);
        text.setSize(d, 9.0);
        return this.registerComponent(text);
    }

    @HostAccess.Export
    public UIButton createButton(String text) {
        UIButton button = new UIButton(text, this);
        button.setSize(Math.max(80, this.client.field_1772.method_1727(text) + 20), 20.0);
        return this.registerComponent(button);
    }

    @HostAccess.Export
    public UIInput createInput(String placeholder) {
        UIInput input = new UIInput(placeholder, this);
        return this.registerComponent(input);
    }

    @HostAccess.Export
    public UIContainer createContainer() {
        UIContainer container = new UIContainer(this);
        return this.registerComponent(container);
    }

    public void removeElement(String id) {
        UIComponent component = this.elements.remove(id);
        if (component != null) {
            this.overlayManager.removeOverlayElement(component);
        }
    }

    public UIComponent getElement(String id) {
        return this.elements.get(id);
    }

    @HostAccess.Export
    public void onResize(Value callback) {
        if (callback != null && callback.canExecute()) {
            this.resizeCallback = callback;
            LOGGER.info("UI resize callback registered.");
        }
    }

    @HostAccess.Export
    public UIImage createImage(String source) {
        UIImage image = new UIImage(source, this);
        image.setSize(64.0, 64.0);
        return this.registerComponent(image);
    }

    public void triggerResizeEvent() {
        if (this.resizeCallback != null && this.scriptExecutor != null && !this.scriptExecutor.isShutdown() && this.jsContext != null) {
            this.scriptExecutor.execute(() -> {
                this.jsContext.enter();
                try {
                    LOGGER.debug("Firing UI resize event to script.");
                    this.resizeCallback.execute(new Object[]{this.getScreenWidth(), this.getScreenHeight()});
                }
                catch (Exception e) {
                    LOGGER.error("Error executing UI resize callback", (Throwable)e);
                }
                finally {
                    this.jsContext.leave();
                }
            });
        }
    }

    public void cleanUp() {
        this.elements.values().forEach(this.overlayManager::removeOverlayElement);
        this.elements.clear();
        this.jsContext = null;
        this.scriptExecutor = null;
        LOGGER.info("UIService cleaned up.");
    }
}

