/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.camera;

import com.moud.api.math.Vector3;
import net.minecraft.class_1297;
import net.minecraft.class_4184;

public abstract class CameraAPI {
    protected boolean enabled = false;
    protected Vector3 position = Vector3.zero();
    public Vector3 prevPosition = Vector3.zero();
    public Vector3 targetPosition = Vector3.zero();
    protected float yaw = 0.0f;
    protected float pitch = 0.0f;
    protected float roll = 0.0f;
    protected float fov = 70.0f;
    protected class_1297 trackedEntity = null;
    protected boolean globalMode = false;
    protected boolean chunkLoadingEnabled = false;
    protected boolean collisionEnabled = false;

    public abstract void initialize();

    public abstract void tick(float var1);

    public abstract void applyTransformation(class_4184 var1);

    public abstract void handleInput(double var1, double var3, double var5);

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.onEnable();
        } else {
            this.onDisable();
        }
    }

    protected void onEnable() {
        this.prevPosition = this.position;
        this.targetPosition = this.position;
    }

    protected void onDisable() {
    }

    public void setPosition(double x, double y, double z) {
        this.position = new Vector3((float)x, (float)y, (float)z);
    }

    public void setPosition(Vector3 pos) {
        this.position = pos;
    }

    public void addPosition(double x, double y, double z) {
        this.position = this.position.add(new Vector3((float)x, (float)y, (float)z));
    }

    public Vector3 getPosition() {
        return this.position;
    }

    public Vector3 getPrevPosition() {
        return this.prevPosition;
    }

    public Vector3 getTargetPosition() {
        return this.targetPosition;
    }

    public void setRotation(float yaw, float pitch, float roll) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setRoll(float roll) {
        this.roll = roll;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getRoll() {
        return this.roll;
    }

    public void setFOV(float fov) {
        this.fov = Math.max(1.0f, Math.min(170.0f, fov));
    }

    public float getFOV() {
        return this.fov;
    }

    public void moveForward(double distance) {
        double radYaw = Math.toRadians(this.yaw);
        double radPitch = Math.toRadians(this.pitch);
        float x = (float)(-Math.sin(radYaw) * Math.cos(radPitch) * distance);
        float y = (float)(-Math.sin(radPitch) * distance);
        float z = (float)(Math.cos(radYaw) * Math.cos(radPitch) * distance);
        this.addPosition(x, y, z);
    }

    public void moveRight(double distance) {
        double radYaw = Math.toRadians(this.yaw + 90.0f);
        float x = (float)(-Math.sin(radYaw) * distance);
        float z = (float)(Math.cos(radYaw) * distance);
        this.addPosition(x, 0.0, z);
    }

    public void moveUp(double distance) {
        this.addPosition(0.0, distance, 0.0);
    }

    public void trackEntity(class_1297 entity) {
        this.trackedEntity = entity;
    }

    public void stopTracking() {
        this.trackedEntity = null;
    }

    public boolean isTrackingEntity() {
        return this.trackedEntity != null;
    }

    public void setGlobalMode(boolean global) {
        this.globalMode = global;
    }

    public boolean isGlobalMode() {
        return this.globalMode;
    }

    public void setChunkLoadingEnabled(boolean enabled) {
        this.chunkLoadingEnabled = enabled;
    }

    public boolean isChunkLoadingEnabled() {
        return this.chunkLoadingEnabled;
    }

    public void setCollisionEnabled(boolean enabled) {
        this.collisionEnabled = enabled;
    }

    public boolean isCollisionEnabled() {
        return this.collisionEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void reset() {
        this.position = Vector3.zero();
        this.prevPosition = Vector3.zero();
        this.targetPosition = Vector3.zero();
        this.yaw = 0.0f;
        this.pitch = 0.0f;
        this.roll = 0.0f;
        this.fov = 70.0f;
        this.trackedEntity = null;
        this.globalMode = false;
        this.chunkLoadingEnabled = false;
        this.collisionEnabled = false;
    }

    protected float lerpAngle(float start, float end, float factor) {
        float diff;
        for (diff = end - start; diff > 180.0f; diff -= 360.0f) {
        }
        while (diff < -180.0f) {
            diff += 360.0f;
        }
        return start + diff * factor;
    }
}

