/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.cursor;

import com.moud.api.math.Vector3;
import com.moud.client.cursor.CursorRenderer;
import com.moud.client.cursor.RemoteCursor;
import com.moud.network.MoudPackets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCursorManager {
    private static ClientCursorManager instance;
    private static final Logger LOGGER;
    private final Map<UUID, RemoteCursor> remoteCursors = new ConcurrentHashMap<UUID, RemoteCursor>();
    private final CursorRenderer renderer = new CursorRenderer();
    private final class_310 client = class_310.method_1551();

    private ClientCursorManager() {
    }

    public static synchronized ClientCursorManager getInstance() {
        if (instance == null) {
            instance = new ClientCursorManager();
        }
        return instance;
    }

    public void handlePositionUpdates(List<MoudPackets.CursorUpdateData> updates) {
        if (this.client.field_1724 == null) {
            return;
        }
        LOGGER.trace("Handling {} cursor position updates.", (Object)updates.size());
        for (MoudPackets.CursorUpdateData update : updates) {
            RemoteCursor cursor = this.remoteCursors.computeIfAbsent(update.playerId(), id -> {
                LOGGER.info("Creating new remote cursor for player {}", id);
                return new RemoteCursor((UUID)id);
            });
            cursor.setTargetPosition(update.position(), update.normal());
        }
    }

    public void handleAppearanceUpdate(UUID playerId, String texture, Vector3 color, float scale, String renderMode) {
        RemoteCursor cursor = this.remoteCursors.computeIfAbsent(playerId, id -> {
            LOGGER.info("Creating cursor for appearance update: {}", id);
            return new RemoteCursor((UUID)id);
        });
        cursor.setAppearance(texture, color, scale, renderMode);
    }

    public void handleVisibilityUpdate(UUID playerId, boolean visible) {
        RemoteCursor cursor = this.remoteCursors.computeIfAbsent(playerId, id -> {
            LOGGER.info("Creating cursor for visibility update: {}", id);
            return new RemoteCursor((UUID)id);
        });
        cursor.setVisible(visible);
    }

    public void handleRemoveCursors(List<UUID> playerIds) {
        for (UUID playerId : playerIds) {
            RemoteCursor removed = this.remoteCursors.remove(playerId);
            if (removed == null) continue;
            LOGGER.info("Removed cursor for player {}", (Object)playerId);
        }
    }

    public void tick(float tickDelta) {
        for (RemoteCursor cursor : this.remoteCursors.values()) {
            cursor.update(tickDelta);
        }
    }

    public void render(class_4587 matrices, class_4597 consumers, float tickDelta) {
        if (this.remoteCursors.isEmpty()) {
            return;
        }
        for (RemoteCursor cursor : this.remoteCursors.values()) {
            if (!cursor.isVisible() || cursor.getTexture() == null) continue;
            this.renderer.render(cursor, matrices, consumers, tickDelta);
        }
    }

    public void clear() {
        LOGGER.info("Clearing {} cursors", (Object)this.remoteCursors.size());
        this.remoteCursors.clear();
    }

    static {
        LOGGER = LoggerFactory.getLogger(ClientCursorManager.class);
    }
}

