/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.cursor;

import com.moud.api.math.Vector3;
import com.moud.client.cursor.RemoteCursor;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursorRenderer {
    private final class_310 client = class_310.method_1551();
    private static final Logger LOGGER = LoggerFactory.getLogger(CursorRenderer.class);
    private static final class_2960 FALLBACK_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/block/white_concrete.png");

    public void render(RemoteCursor cursor, class_4587 matrices, class_4597 consumers, float tickDelta) {
        class_4184 camera = this.client.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        Vector3 interpolatedPos = cursor.getInterpolatedPosition(tickDelta);
        if (interpolatedPos.equals((Object)Vector3.zero())) {
            return;
        }
        class_243 worldPos = new class_243((double)interpolatedPos.x, (double)interpolatedPos.y, (double)interpolatedPos.z);
        Vector3f relativePos = worldPos.method_1020(cameraPos).method_46409();
        double distance = cameraPos.method_1022(worldPos);
        if (distance > 100.0) {
            return;
        }
        matrices.method_22903();
        matrices.method_46416(relativePos.x, relativePos.y, relativePos.z);
        Vector3 normal = cursor.getInterpolatedNormal(tickDelta);
        matrices.method_46416(normal.x * 0.02f, normal.y * 0.02f, normal.z * 0.02f);
        matrices.method_22907(camera.method_23767());
        matrices.method_22907(new Quaternionf().rotateY((float)Math.PI));
        float scale = cursor.getScale() * 1.0f;
        matrices.method_22905(scale, scale, scale);
        class_2960 textureId = cursor.getTexture();
        if (textureId == null) {
            textureId = FALLBACK_TEXTURE;
        }
        class_1921 renderLayer = class_1921.method_23580((class_2960)textureId);
        class_4588 consumer = consumers.getBuffer(renderLayer);
        this.renderQuad(consumer, matrices, cursor);
        matrices.method_22909();
        if (consumers instanceof class_4597.class_4598) {
            class_4597.class_4598 immediate = (class_4597.class_4598)consumers;
            immediate.method_22994(renderLayer);
        }
    }

    private void renderQuad(class_4588 consumer, class_4587 matrices, RemoteCursor cursor) {
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f positionMatrix = entry.method_23761();
        Vector3 color = cursor.getColor();
        float r = color.x;
        float g = color.y;
        float b = color.z;
        float alpha = 0.9f;
        float size = 0.5f;
        int light = 0xF000F0;
        int overlay = class_4608.field_21444;
        consumer.method_22918(positionMatrix, -size, -size, 0.0f).method_22915(r, g, b, alpha).method_22913(0.0f, 1.0f).method_22922(overlay).method_60803(light).method_22914(0.0f, 0.0f, 1.0f);
        consumer.method_22918(positionMatrix, size, -size, 0.0f).method_22915(r, g, b, alpha).method_22913(1.0f, 1.0f).method_22922(overlay).method_60803(light).method_22914(0.0f, 0.0f, 1.0f);
        consumer.method_22918(positionMatrix, size, size, 0.0f).method_22915(r, g, b, alpha).method_22913(1.0f, 0.0f).method_22922(overlay).method_60803(light).method_22914(0.0f, 0.0f, 1.0f);
        consumer.method_22918(positionMatrix, -size, size, 0.0f).method_22915(r, g, b, alpha).method_22913(0.0f, 0.0f).method_22922(overlay).method_60803(light).method_22914(0.0f, 0.0f, 1.0f);
    }
}

