/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.cursor;

import com.moud.api.math.Vector3;
import java.util.UUID;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteCursor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteCursor.class);
    private final UUID playerId;
    private boolean visible = false;
    private boolean enabled = true;
    private class_2960 texture;
    private Vector3 color = new Vector3(1.0f, 1.0f, 1.0f);
    private float scale = 0.8f;
    private String renderMode = "TEXTURE";
    private Vector3 currentPosition;
    private Vector3 previousPosition;
    private Vector3 currentNormal;
    private Vector3 previousNormal;

    public RemoteCursor(UUID playerId) {
        this.playerId = playerId;
        this.currentPosition = Vector3.zero();
        this.previousPosition = Vector3.zero();
        this.currentNormal = new Vector3(0.0f, 1.0f, 0.0f);
        this.previousNormal = new Vector3(0.0f, 1.0f, 0.0f);
        this.setDefaultTexture();
        LOGGER.info("Created RemoteCursor for player {}", (Object)playerId);
    }

    private void setDefaultTexture() {
        this.texture = class_2960.method_60655((String)"minecraft", (String)"textures/block/white_concrete.png");
        LOGGER.debug("Set default texture for cursor {}: {}", (Object)this.playerId, (Object)this.texture);
    }

    public void update(float tickDelta) {
    }

    public void setTargetPosition(Vector3 pos, Vector3 normal) {
        this.previousPosition = this.currentPosition;
        this.previousNormal = this.currentNormal;
        this.currentPosition = pos;
        this.currentNormal = normal;
        LOGGER.debug("Updated cursor {} position: prev={}, current={}", new Object[]{this.playerId, this.previousPosition, this.currentPosition});
    }

    public Vector3 getInterpolatedPosition(float tickProgress) {
        return Vector3.lerp((Vector3)this.previousPosition, (Vector3)this.currentPosition, (float)tickProgress);
    }

    public Vector3 getInterpolatedNormal(float tickProgress) {
        return Vector3.lerp((Vector3)this.previousNormal, (Vector3)this.currentNormal, (float)tickProgress).normalize();
    }

    public void setAppearance(String textureString, Vector3 color, float scale, String renderMode) {
        LOGGER.info("Setting appearance for cursor {}: texture={}, color={}, scale={}", new Object[]{this.playerId, textureString, color, Float.valueOf(scale)});
        if (textureString != null && !textureString.isEmpty()) {
            class_2960 parsedTexture = class_2960.method_12829((String)textureString);
            if (parsedTexture != null) {
                this.texture = parsedTexture;
                LOGGER.debug("Successfully set texture to {}", (Object)parsedTexture);
            } else {
                LOGGER.warn("Failed to parse texture {}, using default", (Object)textureString);
                this.setDefaultTexture();
            }
        } else {
            LOGGER.warn("Empty texture string, using default");
            this.setDefaultTexture();
        }
        this.color = color != null ? color : new Vector3(1.0f, 1.0f, 1.0f);
        this.scale = scale;
        this.renderMode = renderMode != null ? renderMode : "TEXTURE";
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public boolean isVisible() {
        return this.visible && this.enabled;
    }

    public void setVisible(boolean visible) {
        LOGGER.info("Setting cursor {} visibility to {}", (Object)this.playerId, (Object)visible);
        this.visible = visible;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public Vector3 getColor() {
        return this.color;
    }

    public float getScale() {
        return this.scale;
    }

    public Vector3 getCurrentPosition() {
        return this.currentPosition;
    }

    public Vector3 getCurrentNormal() {
        return this.currentNormal;
    }
}

