/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.lighting;

import com.moud.api.math.Conversion;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.AreaLightData;
import foundry.veil.api.client.render.light.data.LightData;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_243;
import net.minecraft.class_310;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientLightingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientLightingService.class);
    private static final ClientLightingService INSTANCE = new ClientLightingService();
    private static final float LIGHT_RENDER_DISTANCE_SQUARED = 16384.0f;
    private final Map<Long, ManagedLight> managedLights = new ConcurrentHashMap<Long, ManagedLight>();
    private final class_310 client = class_310.method_1551();
    private long lastFrameTime = 0L;
    private static final Vector3f UP_VECTOR = new Vector3f(0.0f, 1.0f, 0.0f);
    private boolean initialized = false;

    private ClientLightingService() {
    }

    public static ClientLightingService getInstance() {
        return INSTANCE;
    }

    public void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            LOGGER.info("ClientLightingService initialized.");
        }
    }

    public void handleCreateOrUpdateLight(Map<String, Object> lightData) {
        if (!this.initialized) {
            this.initialize();
        }
        long id = Conversion.toLong((Object)lightData.get("id"));
        ManagedLight light = this.managedLights.computeIfAbsent(id, key -> {
            String type = (String)lightData.get("type");
            LOGGER.info("Creating new managed light with ID: {} and type: {}", key, (Object)type);
            return new ManagedLight((long)key, type);
        });
        light.update(lightData);
        light.snap();
        LOGGER.debug("Updated light ID: {} with data: {}", (Object)id, lightData);
    }

    public void handleLightSync(Map<String, Object> data) {
        LOGGER.info("Syncing lights from server...");
        this.clearAllLights();
        List lights = (List)data.get("lights");
        if (lights != null) {
            LOGGER.info("Syncing {} lights", (Object)lights.size());
            for (Map lightData : lights) {
                this.handleCreateOrUpdateLight(lightData);
            }
        }
    }

    public void handleRemoveLight(long id) {
        ManagedLight managed = this.managedLights.remove(id);
        if (managed != null) {
            this.destroyVeilLight(managed);
            LOGGER.info("Removed light with ID: {}", (Object)id);
        }
    }

    private void clearAllLights() {
        LOGGER.info("Clearing all {} lights", (Object)this.managedLights.size());
        this.managedLights.values().forEach(this::destroyVeilLight);
        this.managedLights.clear();
    }

    public void tick() {
        if (this.client.field_1724 == null || !this.initialized) {
            this.lastFrameTime = 0L;
            return;
        }
        long currentTime = System.nanoTime();
        if (this.lastFrameTime == 0L) {
            this.lastFrameTime = currentTime;
            return;
        }
        float deltaTime = (float)(currentTime - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = currentTime;
        class_243 playerPos = this.client.field_1724.method_19538();
        for (ManagedLight light : this.managedLights.values()) {
            boolean shouldBeVisible;
            boolean bl = shouldBeVisible = playerPos.method_1025(light.targetPosition) < 16384.0;
            if (shouldBeVisible) {
                if (light.veilLightData == null) {
                    this.createVeilLight(light);
                }
                light.interpolate(deltaTime);
                this.updateVeilLight(light);
                continue;
            }
            if (light.veilLightData == null) continue;
            this.destroyVeilLight(light);
        }
    }

    private void createVeilLight(ManagedLight managed) {
        try {
            if ("point".equals(managed.type)) {
                PointLightData pointLight = new PointLightData();
                managed.veilLightData = pointLight;
                this.updateVeilLight(managed);
                VeilRenderSystem.renderer().getLightRenderer().addLight((LightData)pointLight);
                LOGGER.info("Created Veil point light with ID: {}", (Object)managed.id);
            } else if ("area".equals(managed.type)) {
                AreaLightData areaLight = new AreaLightData();
                managed.veilLightData = areaLight;
                this.updateVeilLight(managed);
                VeilRenderSystem.renderer().getLightRenderer().addLight((LightData)areaLight);
                LOGGER.info("Created Veil area light with ID: {}", (Object)managed.id);
            } else {
                LOGGER.warn("Attempted to create a Veil light with an unknown type: {}", (Object)managed.type);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create Veil light of type '{}' with id {}", new Object[]{managed.type, managed.id, e});
        }
    }

    private void updateVeilLight(ManagedLight managed) {
        try {
            LightData lightData = managed.veilLightData;
            if (lightData instanceof PointLightData) {
                PointLightData pointLight = (PointLightData)lightData;
                pointLight.setPosition((double)((float)managed.interpolatedPosition.field_1352), (double)((float)managed.interpolatedPosition.field_1351), (double)((float)managed.interpolatedPosition.field_1350)).setColor(managed.r, managed.g, managed.b).setBrightness(managed.brightness).setRadius(managed.radius);
            } else if (lightData instanceof AreaLightData) {
                AreaLightData areaLight = (AreaLightData)lightData;
                areaLight.getPosition().set((double)((float)managed.interpolatedPosition.field_1352), (double)((float)managed.interpolatedPosition.field_1351), (double)((float)managed.interpolatedPosition.field_1350));
                double dirLength = managed.interpolatedDirection.method_1033();
                if (dirLength > 0.001) {
                    class_243 normalizedDir = managed.interpolatedDirection.method_1029();
                    Vector3f direction = new Vector3f((float)normalizedDir.field_1352 * -1.0f, (float)normalizedDir.field_1351 * -1.0f, (float)normalizedDir.field_1350 * -1.0f);
                    Quaternionf tempOrientation = new Quaternionf();
                    float dotWithUp = direction.dot((Vector3fc)UP_VECTOR);
                    if (Math.abs(Math.abs(dotWithUp) - 1.0f) < 0.001f) {
                        if (dotWithUp > 0.0f) {
                            tempOrientation.rotationX((float)Math.PI);
                        }
                    } else {
                        Vector3f safeUp = new Vector3f(0.0f, 0.0f, 1.0f);
                        tempOrientation.lookAlong((Vector3fc)direction, (Vector3fc)safeUp);
                    }
                    areaLight.getOrientation().set((Quaternionfc)tempOrientation);
                } else {
                    Quaternionf tempOrientation = new Quaternionf();
                    areaLight.getOrientation().set((Quaternionfc)tempOrientation);
                }
                areaLight.setColor(managed.r, managed.g, managed.b).setBrightness(managed.brightness).setSize((double)managed.width, (double)managed.height).setDistance(managed.distance).setAngle(managed.angle);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to update Veil light with ID: {}", (Object)managed.id, (Object)e);
        }
    }

    private void destroyVeilLight(ManagedLight managed) {
        if (managed.veilLightData != null) {
            try {
                LightRenderer lightRenderer = VeilRenderSystem.renderer().getLightRenderer();
                lightRenderer.getLights(managed.veilLightData.getType()).removeIf(handle -> handle.getLightData() == managed.veilLightData);
                managed.veilLightData = null;
                LOGGER.debug("Destroyed Veil light with ID: {}", (Object)managed.id);
            }
            catch (Exception e) {
                LOGGER.error("Failed to destroy Veil light with ID: {}", (Object)managed.id, (Object)e);
            }
        }
    }

    public void cleanup() {
        this.client.execute(this::clearAllLights);
        LOGGER.info("ClientLightingService session cleaned up (lights cleared).");
    }

    private static class ManagedLight {
        final long id;
        final String type;
        LightData veilLightData;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float brightness = 1.0f;
        float radius = 5.0f;
        float width = 1.0f;
        float height = 1.0f;
        float angle = 45.0f;
        float distance = 10.0f;
        class_243 interpolatedPosition;
        class_243 targetPosition;
        class_243 interpolatedDirection;
        class_243 targetDirection;

        ManagedLight(long id, String type) {
            this.id = id;
            this.type = type;
            this.interpolatedPosition = class_243.field_1353;
            this.targetPosition = class_243.field_1353;
            this.interpolatedDirection = new class_243(0.0, -1.0, 0.0);
            this.targetDirection = new class_243(0.0, -1.0, 0.0);
        }

        void update(Map<String, Object> data) {
            this.r = Conversion.toFloat((Object)data.getOrDefault("r", Float.valueOf(this.r)));
            this.g = Conversion.toFloat((Object)data.getOrDefault("g", Float.valueOf(this.g)));
            this.b = Conversion.toFloat((Object)data.getOrDefault("b", Float.valueOf(this.b)));
            this.brightness = Conversion.toFloat((Object)data.getOrDefault("brightness", Float.valueOf(this.brightness)));
            this.angle = Conversion.toFloat((Object)data.getOrDefault("angle", Float.valueOf(this.angle)));
            this.distance = Conversion.toFloat((Object)data.getOrDefault("distance", Float.valueOf(this.distance)));
            LOGGER.info("Light {} received data: {}", (Object)this.id, data);
            LOGGER.info("Direction values - dirX: {}, dirY: {}, dirZ: {}", new Object[]{data.get("dirX"), data.get("dirY"), data.get("dirZ")});
            if (data.containsKey("x")) {
                this.targetPosition = new class_243(Conversion.toDouble((Object)data.get("x")), Conversion.toDouble((Object)data.get("y")), Conversion.toDouble((Object)data.get("z")));
            }
            if ("point".equals(this.type)) {
                this.radius = Conversion.toFloat((Object)data.getOrDefault("radius", Float.valueOf(this.radius)));
            } else if ("area".equals(this.type)) {
                this.width = Conversion.toFloat((Object)data.getOrDefault("width", Float.valueOf(this.width)));
                this.height = Conversion.toFloat((Object)data.getOrDefault("height", Float.valueOf(this.height)));
                if (data.containsKey("dirX")) {
                    Object dirXObj = data.get("dirX");
                    Object dirYObj = data.get("dirY");
                    Object dirZObj = data.get("dirZ");
                    LOGGER.info("Direction object types - dirX: {} ({}), dirY: {} ({}), dirZ: {} ({})", new Object[]{dirXObj, dirXObj == null ? "null" : dirXObj.getClass().getName(), dirYObj, dirYObj == null ? "null" : dirYObj.getClass().getName(), dirZObj, dirZObj == null ? "null" : dirZObj.getClass().getName()});
                    double dirX = Conversion.toDouble((Object)dirXObj);
                    double dirY = Conversion.toDouble((Object)dirYObj);
                    double dirZ = Conversion.toDouble((Object)dirZObj);
                    LOGGER.info("After Conversion.toDouble - dirX: {}, dirY: {}, dirZ: {}", new Object[]{dirX, dirY, dirZ});
                    class_243 rawDirection = new class_243(dirX, dirY, dirZ);
                    LOGGER.info("Vec3d created - x: {}, y: {}, z: {}, length: {}", new Object[]{rawDirection.field_1352, rawDirection.field_1351, rawDirection.field_1350, rawDirection.method_1033()});
                    double length = rawDirection.method_1033();
                    if (length > 0.001) {
                        this.targetDirection = rawDirection.method_1029();
                        LOGGER.info("Normalized direction: x: {}, y: {}, z: {}", new Object[]{this.targetDirection.field_1352, this.targetDirection.field_1351, this.targetDirection.field_1350});
                    } else {
                        LOGGER.warn("Zero-length direction for light {}, using default", (Object)this.id);
                        this.targetDirection = new class_243(0.0, -1.0, 0.0);
                    }
                }
            }
            if (this.veilLightData == null) {
                this.snap();
            }
        }

        void interpolate(float deltaTime) {
            float smoothing = 20.0f;
            float factor = 1.0f - (float)Math.exp(-smoothing * deltaTime);
            this.interpolatedPosition = this.interpolatedPosition.method_35590(this.targetPosition, (double)factor);
            if (this.targetDirection.method_1027() > 0.001) {
                this.interpolatedDirection = this.interpolatedDirection.method_35590(this.targetDirection, (double)factor);
                double length = this.interpolatedDirection.method_1033();
                if (length > 0.001) {
                    this.interpolatedDirection = this.interpolatedDirection.method_1029();
                }
            }
        }

        void snap() {
            this.interpolatedPosition = this.targetPosition;
            this.interpolatedDirection = this.targetDirection;
        }
    }
}

