/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.movement;

import com.moud.client.network.ClientPacketWrapper;
import com.moud.network.MoudPackets;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_746;

public class ClientMovementTracker {
    private static ClientMovementTracker instance;
    private final class_310 client = class_310.method_1551();
    private boolean lastForward = false;
    private boolean lastBackward = false;
    private boolean lastLeft = false;
    private boolean lastRight = false;
    private boolean lastJumping = false;
    private boolean lastSneaking = false;
    private boolean lastSprinting = false;
    private boolean lastOnGround = false;
    private float lastSpeed = 0.0f;
    private int tickCounter = 0;
    private static final int UPDATE_INTERVAL = 5;

    private ClientMovementTracker() {
    }

    public static ClientMovementTracker getInstance() {
        if (instance == null) {
            instance = new ClientMovementTracker();
        }
        return instance;
    }

    public void tick() {
        float speed;
        boolean onGround;
        boolean sprinting;
        boolean sneaking;
        boolean jumping;
        boolean right;
        boolean left;
        boolean backward;
        if (this.client.field_1724 == null) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter < 5) {
            return;
        }
        this.tickCounter = 0;
        class_746 player = this.client.field_1724;
        class_315 options = this.client.field_1690;
        boolean forward = options.field_1894.method_1434();
        if (this.hasStateChanged(forward, backward = options.field_1881.method_1434(), left = options.field_1913.method_1434(), right = options.field_1849.method_1434(), jumping = options.field_1903.method_1434(), sneaking = options.field_1832.method_1434(), sprinting = player.method_5624(), onGround = player.method_24828(), speed = (float)player.method_18798().method_37267())) {
            this.sendMovementState(forward, backward, left, right, jumping, sneaking, sprinting, onGround, speed);
            this.updateLastState(forward, backward, left, right, jumping, sneaking, sprinting, onGround, speed);
        }
    }

    private boolean hasStateChanged(boolean forward, boolean backward, boolean left, boolean right, boolean jumping, boolean sneaking, boolean sprinting, boolean onGround, float speed) {
        return forward != this.lastForward || backward != this.lastBackward || left != this.lastLeft || right != this.lastRight || jumping != this.lastJumping || sneaking != this.lastSneaking || sprinting != this.lastSprinting || onGround != this.lastOnGround || Math.abs(speed - this.lastSpeed) > 0.1f;
    }

    private void updateLastState(boolean forward, boolean backward, boolean left, boolean right, boolean jumping, boolean sneaking, boolean sprinting, boolean onGround, float speed) {
        this.lastForward = forward;
        this.lastBackward = backward;
        this.lastLeft = left;
        this.lastRight = right;
        this.lastJumping = jumping;
        this.lastSneaking = sneaking;
        this.lastSprinting = sprinting;
        this.lastOnGround = onGround;
        this.lastSpeed = speed;
    }

    private void sendMovementState(boolean forward, boolean backward, boolean left, boolean right, boolean jumping, boolean sneaking, boolean sprinting, boolean onGround, float speed) {
        MoudPackets.MovementStatePacket packet = new MoudPackets.MovementStatePacket(forward, backward, left, right, jumping, sneaking, sprinting, onGround, speed);
        ClientPacketWrapper.sendToServer(packet);
    }
}

