/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.player;

import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerStateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayerStateManager.class);
    private static PlayerStateManager instance;
    private final class_310 client = class_310.method_1551();
    private boolean hotbarHidden = false;
    private boolean handHidden = false;
    private boolean experienceHidden = false;
    private boolean healthHidden = false;
    private boolean foodHidden = false;
    private boolean crosshairHidden = false;
    private boolean chatHidden = false;
    private boolean playerListHidden = false;
    private boolean scoreboardHidden = false;

    private PlayerStateManager() {
    }

    public static synchronized PlayerStateManager getInstance() {
        if (instance == null) {
            instance = new PlayerStateManager();
        }
        return instance;
    }

    public void updatePlayerState(boolean hideHotbar, boolean hideHand, boolean hideExperience) {
        this.hotbarHidden = hideHotbar;
        this.handHidden = hideHand;
        this.experienceHidden = hideExperience;
        LOGGER.debug("UI state updated - hotbar: {}, hand: {}, experience: {}", new Object[]{hideHotbar, hideHand, hideExperience});
    }

    public void updateExtendedPlayerState(boolean hideHotbar, boolean hideHand, boolean hideExperience, boolean hideHealth, boolean hideFood, boolean hideCrosshair, boolean hideChat, boolean hidePlayerList, boolean hideScoreboard) {
        this.hotbarHidden = hideHotbar;
        this.handHidden = hideHand;
        this.experienceHidden = hideExperience;
        this.healthHidden = hideHealth;
        this.foodHidden = hideFood;
        this.crosshairHidden = hideCrosshair;
        this.chatHidden = hideChat;
        this.playerListHidden = hidePlayerList;
        this.scoreboardHidden = hideScoreboard;
        LOGGER.debug("UI state updated");
    }

    public boolean isHotbarHidden() {
        return this.hotbarHidden;
    }

    public boolean isHandHidden() {
        return this.handHidden;
    }

    public boolean isExperienceHidden() {
        return this.experienceHidden;
    }

    public boolean isHealthHidden() {
        return this.healthHidden;
    }

    public boolean isFoodHidden() {
        return this.foodHidden;
    }

    public boolean isCrosshairHidden() {
        return this.crosshairHidden;
    }

    public boolean isChatHidden() {
        return this.chatHidden;
    }

    public boolean isPlayerListHidden() {
        return this.playerListHidden;
    }

    public boolean isScoreboardHidden() {
        return this.scoreboardHidden;
    }

    public void reset() {
        this.hotbarHidden = false;
        this.handHidden = false;
        this.experienceHidden = false;
        this.healthHidden = false;
        this.foodHidden = false;
        this.crosshairHidden = false;
        this.chatHidden = false;
        this.playerListHidden = false;
        this.scoreboardHidden = false;
    }
}

