/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.rendering;

import com.moud.client.api.service.RenderTypeDefinition;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomRenderTypeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomRenderTypeManager.class);
    private final Map<Integer, class_2960> renderTypeCache = new ConcurrentHashMap<Integer, class_2960>();

    public class_2960 getOrCreate(RenderTypeDefinition definition) {
        int hash = definition.hashCode();
        return this.renderTypeCache.computeIfAbsent(hash, k -> {
            try {
                return this.createShaderReference(definition);
            }
            catch (Exception e) {
                LOGGER.error("Failed to create shader reference", (Throwable)e);
                throw new RuntimeException("Failed to create shader reference", e);
            }
        });
    }

    private class_2960 createShaderReference(RenderTypeDefinition definition) {
        class_2960 shaderId = definition.shader();
        LOGGER.debug("Created shader reference: {}", (Object)shaderId);
        return shaderId;
    }

    public void clearCache() {
        this.renderTypeCache.clear();
    }
}

