/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.rendering;

import foundry.veil.api.client.render.VeilRenderSystem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostProcessingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostProcessingManager.class);
    private final Set<class_2960> activeEffects = new HashSet<class_2960>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyEffect(String effectId) {
        try {
            class_2960 pipelineId = class_2960.method_12829((String)effectId);
            if (pipelineId == null) {
                LOGGER.error("Invalid Identifier format: {}", (Object)effectId);
                return;
            }
            Set<class_2960> set = this.activeEffects;
            synchronized (set) {
                if (this.activeEffects.add(pipelineId)) {
                    VeilRenderSystem.renderer().getPostProcessingManager().add(pipelineId);
                    LOGGER.debug("Applied post-processing effect: {}", (Object)pipelineId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply post-processing effect with invalid ID: {}", (Object)effectId, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEffect(String effectId) {
        try {
            class_2960 pipelineId = class_2960.method_12829((String)effectId);
            if (pipelineId == null) {
                LOGGER.error("Invalid Identifier format: {}", (Object)effectId);
                return;
            }
            Set<class_2960> set = this.activeEffects;
            synchronized (set) {
                if (this.activeEffects.remove(pipelineId)) {
                    VeilRenderSystem.renderer().getPostProcessingManager().remove(pipelineId);
                    LOGGER.debug("Removed post-processing effect: {}", (Object)pipelineId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to remove post-processing effect with invalid ID: {}", (Object)effectId, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllEffects() {
        Set<class_2960> set = this.activeEffects;
        synchronized (set) {
            for (class_2960 pipelineId : this.activeEffects) {
                VeilRenderSystem.renderer().getPostProcessingManager().remove(pipelineId);
            }
            this.activeEffects.clear();
            LOGGER.info("Cleared all active post-processing effects.");
        }
    }
}

