/*
 * Decompiled with CFR 0.152.
 */
package com.moud.client.shared;

import com.moud.client.shared.core.ClientValueCache;
import com.moud.client.shared.network.ClientPacketSender;
import com.moud.network.MoudPackets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedValueManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedValueManager.class);
    private static SharedValueManager instance;
    private final ConcurrentHashMap<String, ClientValueCache> stores = new ConcurrentHashMap();
    private final ClientPacketSender packetSender = new ClientPacketSender();

    private SharedValueManager() {
    }

    public static synchronized SharedValueManager getInstance() {
        if (instance == null) {
            instance = new SharedValueManager();
        }
        return instance;
    }

    public ClientValueCache getOrCreateStore(String storeName) {
        return this.stores.computeIfAbsent(storeName, ClientValueCache::new);
    }

    public ClientValueCache getStore(String storeName) {
        return this.stores.get(storeName);
    }

    public void handleServerSync(MoudPackets.SyncSharedValuesPacket packet) {
        String storeName = packet.storeName();
        ClientValueCache store = this.getOrCreateStore(storeName);
        for (Map.Entry entry : packet.deltaChanges().entrySet()) {
            store.updateFromServer((String)entry.getKey(), entry.getValue());
        }
        LOGGER.debug("Applied {} changes to store '{}' from server", (Object)packet.deltaChanges().size(), (Object)storeName);
    }

    public boolean requestUpdate(String storeName, String key, Object value) {
        ClientValueCache store = this.getStore(storeName);
        if (store == null || !store.canModify(key)) {
            return false;
        }
        store.updateOptimistic(key, value);
        this.packetSender.sendUpdate(storeName, key, value);
        return true;
    }

    public void initialize() {
        LOGGER.info("SharedValueManager initialized");
    }

    public void cleanup() {
        this.stores.clear();
        LOGGER.info("SharedValueManager cleaned up");
    }
}

